/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.refinement.ju.testcases.bugfixes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.CapellamodellerPackage;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.handler.helpers.HoldingResource;
import org.polarsys.capella.core.refinement.RefinementMultiple;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.test.framework.helpers.TestHelper;
import org.polarsys.capella.test.refinement.ju.Messages;
import org.polarsys.capella.test.refinement.ju.helpers.ScenarioTestHelper;
import org.polarsys.capella.test.refinement.ju.testcases.RefinementTest;

public abstract class AbstractHoldingResourceTest
extends RefinementTest {
    public AbstractHoldingResourceTest(String testName, String testCaseDesc, List<String> refinementTargetsChoiceId, List<String> refinementTargetProposalsId, String scenarioToRefineId, String scenarioReferenceId, List<String> ambiguityChoicesId, List<List<String>> ambiguitiesProposalsId, List<String> additionalElementsId) {
        super(refinementTargetsChoiceId, refinementTargetProposalsId, scenarioToRefineId, scenarioReferenceId, ambiguityChoicesId, ambiguitiesProposalsId, additionalElementsId);
    }

    @Override
    protected void additionalCheck(Scenario refinedScenario, Scenario referenceScenario) {
        SystemEngineering se = (SystemEngineering)EcoreUtil2.getFirstContainer((EObject)refinedScenario, (EClass)CapellamodellerPackage.Literals.SYSTEM_ENGINEERING);
        TreeIterator iter = se.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            AbstractHoldingResourceTest.assertFalse((boolean)(obj.eResource() instanceof HoldingResource));
        }
    }

    @Override
    public void refinementTest() {
        final Scenario scenario = (Scenario)this._semanticObjectMap.get(this._scenarioToRefineIds.get(0));
        final ArrayList<NamedElement> targets = new ArrayList<NamedElement>();
        for (String target : this._refinementTargetsChoiceId) {
            targets.add((NamedElement)this._semanticObjectMap.get(target));
        }
        final ArrayList<NamedElement> possibleTargets = new ArrayList<NamedElement>();
        for (String possibleTarget : this._refinementTargetProposalsId) {
            EObject obj = (EObject)this._semanticObjectMap.get(possibleTarget);
            if (obj == null) continue;
            possibleTargets.add((NamedElement)obj);
        }
        if (scenario != null) {
            AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                public void run() {
                    try {
                        RefinementMultiple refinement = new RefinementMultiple((NamedElement)scenario){
                            boolean skipSelection;
                            {
                                super($anonymous0);
                                this.skipSelection = false;
                            }

                            protected Map<NamedElement, List<NamedElement>> evaluateTarget(List<Scenario> scenarios) {
                                this.skipSelection = true;
                                Map result = super.evaluateTarget(scenarios);
                                for (Scenario sc : scenarios) {
                                    List evaluatedTargets = (List)result.get(sc);
                                    if (evaluatedTargets == null) continue;
                                    Assert.assertTrue((String)Messages.wrongRefinementTargets, (evaluatedTargets.size() == possibleTargets.size() ? 1 : 0) != 0);
                                    Assert.assertTrue((String)Messages.wrongRefinementTargets, (boolean)evaluatedTargets.containsAll(targets));
                                    Assert.assertTrue((String)Messages.wrongRefinementTargets, (boolean)possibleTargets.containsAll(targets));
                                }
                                this.skipSelection = false;
                                return super.evaluateTarget(scenarios);
                            }

                            protected Map<NamedElement, List<NamedElement>> selectTarget(Map<NamedElement, List<NamedElement>> allTargets) {
                                if (this.skipSelection) {
                                    return allTargets;
                                }
                                if (!targets.isEmpty()) {
                                    HashMap<NamedElement, List<NamedElement>> result = new HashMap<NamedElement, List<NamedElement>>();
                                    ArrayList selectedTargets = new ArrayList();
                                    List<NamedElement> lst = allTargets.get(scenario);
                                    if (lst.containsAll(targets)) {
                                        selectedTargets.addAll(targets);
                                    }
                                    result.put((NamedElement)scenario, selectedTargets);
                                    return result;
                                }
                                return super.selectTarget(allTargets);
                            }
                        };
                        refinement.execute();
                    }
                    catch (ProcessorException exception) {
                        Assert.fail((String)Messages.refinementDoesNotSucceed);
                    }
                }
            };
            TestHelper.getExecutionManager((EObject)scenario).execute((ICommand)cmd);
            for (NamedElement target : targets) {
                Scenario refinedScenario = this.getRefinedScenario(scenario, target);
                if (refinedScenario != null) {
                    ScenarioTestHelper.checkRefinementLink(refinedScenario);
                    this.additionalCheck(refinedScenario, null);
                    continue;
                }
                Assert.fail((String)Messages.noRefinedScenarioCreated);
            }
        } else {
            Assert.fail((String)Messages.modelCannotbeLoaded);
        }
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("BugFixes");
    }
}

