/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.semantic.queries.ju;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryRegistry;
import org.polarsys.capella.common.ui.toolkit.browser.category.ICategory;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.EObjectHelper;

public abstract class AbstractSemanticQueryTestCase
extends BasicTestCase {
    protected abstract String getQueryCategoryIdentifier();

    protected void testQuery(String sourceId, String ... expectedResult) {
        this.testQuery(sourceId, Arrays.asList(expectedResult));
    }

    protected void testQuery(String sourceId, Collection<String> expectedResult) {
        CapellaModel model = this.getTestModel((String)this.getRequiredTestModels().iterator().next());
        EObject testObject = EObjectHelper.getObject((IModel)model, (String)sourceId);
        Collection expectedObjects = EObjectHelper.getObjects((IModel)model, expectedResult);
        ICategory category = this.getCategory(this.getQueryCategoryIdentifier());
        if (category == null) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} doesn't exist", (Object)this.getQueryCategoryIdentifier()), (boolean)false);
        }
        if (!category.isAvailableForType((Object)testObject)) {
            AbstractSemanticQueryTestCase.assertTrue((String)NLS.bind((String)"Query {0} is not applicable for {1}", (Object)this.getQueryCategoryIdentifier(), (Object)EObjectLabelProviderHelper.getText((EObject)testObject)), (boolean)false);
        }
        List objResult = category.compute((Object)testObject);
        HashSet set1 = new HashSet(objResult);
        HashSet set2 = new HashSet(expectedObjects);
        AbstractSemanticQueryTestCase.assertTrue((boolean)set1.equals(set2));
    }

    protected ICategory getCategory(String categoryId) {
        return CategoryRegistry.getInstance().getCategory(categoryId);
    }
}

