/*******************************************************************************
 * Copyright (c) 2017, 2018 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.test.suite.inui.ju;

import java.util.ArrayList;
import java.util.List;

import org.polarsys.capella.test.diagram.filters.ju.testsuites.DiagramFiltersTestSuite;
import org.polarsys.capella.test.diagram.layout.ju.testsuites.LayoutTestSuite;
import org.polarsys.capella.test.diagram.misc.ju.testsuites.DiagramMiscTestSuite;
import org.polarsys.capella.test.diagram.tools.ju.testsuites.main.DiagramToolsTestSuite;
import org.polarsys.capella.test.framework.api.BasicTestArtefact;
import org.polarsys.capella.test.framework.api.BasicTestSuite;
import org.polarsys.capella.test.richtext.ju.testsuites.RichtextTestSuite;

import junit.framework.Test;

/**
 *
 */
public class RunInUIStep5TestSuite extends BasicTestSuite {

  /**
   * Returns the suite. This is required to unary launch this test.
   */
  public static Test suite() {
    return new RunInUIStep5TestSuite();
  }

  @Override
  protected List<BasicTestArtefact> getTests() {
    List<BasicTestArtefact> tests = new ArrayList<BasicTestArtefact>();
    tests.add(new DiagramToolsTestSuite());
    tests.add(new DiagramFiltersTestSuite());
    tests.add(new DiagramMiscTestSuite());
    tests.add(new LayoutTestSuite());
    tests.add(new RichtextTestSuite());

    // tests.add(new DocTestSuite());
    return tests;
  }

}
