/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.flexibility.properties.loader.PropertiesLoader;
import org.polarsys.capella.common.flexibility.properties.property.PropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.test.framework.api.BasicCommandTestCase;
import org.polarsys.capella.test.transition.ju.Messages;

public abstract class TransitionTestCase
extends BasicCommandTestCase {
    IPropertyContext _propertiesContext = null;

    protected void setPreferenceValue(String id, Object value) {
        IProperty property;
        if (this._propertiesContext == null) {
            IProperties properties = new PropertiesLoader().getProperties("capella.core.transition.system.topdown.preferences");
            this._propertiesContext = new PropertyContext(properties);
        }
        if ((property = this._propertiesContext.getProperties().getProperty(id)) == null) {
            TransitionTestCase.assertFalse((String)("Property not found : " + id), (boolean)true);
        }
        this._propertiesContext.setCurrentValue(property, value);
        this._propertiesContext.write(property);
    }

    protected List<EObject> getAllocatedElements(EObject object) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (object instanceof TraceableElement) {
            for (AbstractTrace trace : ((TraceableElement)object).getOutgoingTraces()) {
                result.add((EObject)trace.getTargetElement());
            }
        }
        return result;
    }

    protected List<EObject> getAllocatingElements(EObject object) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (object instanceof TraceableElement) {
            for (AbstractTrace trace : ((TraceableElement)object).getIncomingTraces()) {
                result.add((EObject)trace.getSourceElement());
            }
        }
        return result;
    }

    protected EObject getAllocatingElement(EObject object) {
        return this.mustBeMonoTransitioned(object);
    }

    protected void mustBeOwnedBy(EObject object, EObject container) {
        TransitionTestCase.assertTrue((object != null ? 1 : 0) != 0);
        TransitionTestCase.assertTrue((boolean)object.eContainer().equals(container));
    }

    protected EObject mustBeMonoTransitioned(String id) {
        EObject element = this.getObject(id);
        return this.mustBeMultiTransitioned(element, 1).get(0);
    }

    protected EObject mustBeMonoTransitioned(EObject element) {
        return this.mustBeMultiTransitioned(element, 1).get(0);
    }

    protected void mustBeNamed(EObject result, String name) {
        TransitionTestCase.assertTrue((boolean)((AbstractNamedElement)result).getName().equals(name));
    }

    protected List<EObject> mustBeMultiTransitioned(String id, int nb) {
        EObject element = this.getObject(id);
        return this.mustBeMultiTransitioned(element, nb);
    }

    protected List<EObject> mustBeMultiTransitioned(EObject element, int nb) {
        TransitionTestCase.assertNotNull((Object)NLS.bind((String)Messages.NullElement, (Object)EObjectLabelProviderHelper.getText((EObject)element)));
        List<EObject> a4t = this.getAllocatingElements(element);
        TransitionTestCase.assertTrue((String)NLS.bind((String)"Should be equals to ''{0}'' but was ''{1}''", (Object)nb, (Object)a4t.size()), (a4t.size() == nb ? 1 : 0) != 0);
        return a4t;
    }

    protected EObject mustBeLinkedTo(String sourceId, String targetId, EStructuralFeature feature) {
        EObject source = this.getObject(sourceId);
        EObject target = this.getObject(targetId);
        return this.mustBeLinkedTo(source, target, feature);
    }

    protected EObject mustBeLinkedTo(EObject source, EObject target, EStructuralFeature feature) {
        if (feature.isMany()) {
            TransitionTestCase.assertTrue((String)NLS.bind((String)"''{0}'' should be linked to ''{1}'' by ''{2}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)source), EObjectLabelProviderHelper.getText((EObject)target), feature.getName()}), (boolean)((EList)source.eGet(feature)).contains((Object)target));
        } else {
            TransitionTestCase.assertTrue((String)NLS.bind((String)"''{0}'' should be linked to ''{1}'' by ''{2}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)source), EObjectLabelProviderHelper.getText((EObject)target), feature.getName()}), (boolean)target.equals(source.eGet(feature)));
        }
        return source;
    }

    protected EObject mustNotBeLinkedTo(String sourceId, String targetId, EStructuralFeature feature) {
        EObject source = this.getObject(sourceId);
        EObject target = this.getObject(targetId);
        return this.mustNotBeLinkedTo(source, target, feature);
    }

    protected EObject mustNotBeLinkedTo(EObject source, EObject target, EStructuralFeature feature) {
        if (feature.isMany()) {
            TransitionTestCase.assertFalse((String)NLS.bind((String)"''{0}'' should be linked to ''{1}'' by ''{2}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)source), EObjectLabelProviderHelper.getText((EObject)target), feature.getName()}), (boolean)((EList)source.eGet(feature)).contains((Object)target));
        } else {
            TransitionTestCase.assertFalse((String)NLS.bind((String)"''{0}'' should be linked to ''{1}'' by ''{2}''", (Object[])new Object[]{EObjectLabelProviderHelper.getText((EObject)source), EObjectLabelProviderHelper.getText((EObject)target), feature.getName()}), (boolean)target.equals(source.eGet(feature)));
        }
        return source;
    }

    public EObject mustBeTransitionedAndLinkedTo(String id, String id2, EStructuralFeature feature) {
        EObject source = this.getObject(id);
        EObject tSource = this.getAllocatingElement(source);
        EObject target = this.getObject(id2);
        this.testReferenceLinked(tSource, target, feature);
        return source;
    }

    public EObject mustBeTransitionedAndLinkedToTransitioned(String id, String id2, EStructuralFeature feature) {
        EObject source = this.getObject(id);
        EObject tSource = this.getAllocatingElement(source);
        EObject target = this.getObject(id2);
        EObject tTarget = this.getAllocatingElement(target);
        this.testReferenceLinked(tSource, tTarget, feature);
        return source;
    }

    public EObject mustBeTransitionedAndNotLinkedTo(String id, String id2, EStructuralFeature feature) {
        EObject source = this.getObject(id);
        EObject tSource = this.getAllocatingElement(source);
        EObject target = this.getObject(id2);
        this.testReferenceNotLinked(tSource, target, feature);
        return source;
    }

    public EObject mustBeTransitionedAndNotLinkedToTransitioned(String id, String id2, EStructuralFeature feature) {
        EObject source = this.getObject(id);
        EObject tSource = this.getAllocatingElement(source);
        EObject target = this.getObject(id2);
        EObject tTarget = this.getAllocatingElement(target);
        this.testReferenceNotLinked(tSource, tTarget, feature);
        return source;
    }

    public void testReferenceLinked(EObject source, EObject target, EStructuralFeature feature) {
        if (feature.isMany()) {
            TransitionTestCase.assertTrue((boolean)((EList)source.eGet(feature)).contains((Object)target));
        } else {
            TransitionTestCase.assertTrue((boolean)source.eGet(feature).equals(target));
        }
    }

    public void testReferenceNotLinked(EObject source, EObject target, EStructuralFeature feature) {
        if (target == null) {
            if (feature.isMany()) {
                TransitionTestCase.assertTrue((source.eGet(feature) == null || !((EList)source.eGet(feature)).contains(null) ? 1 : 0) != 0);
            } else {
                TransitionTestCase.assertTrue((source.eGet(feature) == null ? 1 : 0) != 0);
            }
        } else if (feature.isMany()) {
            TransitionTestCase.assertTrue((!source.eGet(feature).equals(target) && !((EList)source.eGet(feature)).contains((Object)target) ? 1 : 0) != 0);
        } else {
            TransitionTestCase.assertTrue((!source.eGet(feature).equals(target) ? 1 : 0) != 0);
        }
    }

    protected <T extends EObject> T mustBeTransitioned(String id) {
        EObject a4 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)a4);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        EObject a4t = this.getAllocatingElement(a4);
        String namet = String.valueOf(name) + "t";
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeTransitioned, (Object)namet), (Object)a4t);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)name), (Object)a4t.eContainer());
        return (T)a4t;
    }

    protected EObject mustBeTransitionedIndirecltyContainedBy(String id, EObject container) {
        EObject a4 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)a4);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        EObject a4t = this.getAllocatingElement(a4);
        String namet = String.valueOf(name) + "t";
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeTransitioned, (Object)namet), (Object)a4t);
        String containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)namet, (Object)containerName), (boolean)EcoreUtil2.isOrIsContainedBy((EObject)a4t, (EObject)container));
        return a4t;
    }

    protected EObject mustBeTransitioned(String id, EObject container) {
        EObject a4 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)a4);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        EObject a4t = this.getAllocatingElement(a4);
        String namet = String.valueOf(name) + "t";
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.ShouldBeTransitioned, (Object)namet), (Object)a4t);
        String containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)namet, (Object)containerName), (a4t.eContainer() == container ? 1 : 0) != 0);
        return a4t;
    }

    protected EObject mustBeTransitionedAndReference(String id, EObject container) {
        EObject a4 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)a4);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a4);
        EObject obj = this.mustBeTransitionedTo(id, a4.eClass(), container);
        EReference[] references = new EReference[]{};
        if (obj instanceof InteractionFragment) {
            references = new EReference[]{InteractionPackage.Literals.INTERACTION_FRAGMENT__COVERED_INSTANCE_ROLES};
        }
        EReference[] eReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            EReference reference = eReferenceArray[n2];
            Object sourceRef = a4.eGet((EStructuralFeature)reference);
            Object targetRef = obj.eGet((EStructuralFeature)reference);
            if (sourceRef == null) {
                TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)reference.getName(), (Object)sourceRef), (targetRef == null ? 1 : 0) != 0);
            } else if (sourceRef instanceof List && targetRef instanceof List) {
                TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)reference.getName(), (Object)("" + ((List)sourceRef).size())), (((List)sourceRef).size() == ((List)targetRef).size() ? 1 : 0) != 0);
            } else {
                TransitionTestCase.assertFalse((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)reference.getName(), (Object)sourceRef), (sourceRef == null ? 1 : 0) != 0);
            }
            ++n2;
        }
        return obj;
    }

    protected EObject mustBeTransitionedTo(String id, EClass clazz) {
        EObject lc1 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)lc1);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)lc1);
        String namet = String.valueOf(name) + "t";
        for (EObject a4t : this.getAllocatingElements(lc1)) {
            if (!clazz.isInstance((Object)a4t)) continue;
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)namet), (boolean)true);
            return a4t;
        }
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)namet), (boolean)false);
        return null;
    }

    protected EObject mustBeTransitionedTo(String id, EClass clazz, EObject container) {
        EObject lc1 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)lc1);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)lc1);
        String namet = String.valueOf(name) + "t";
        for (EObject a4t : this.getAllocatingElements(lc1)) {
            String containerName;
            if (!clazz.isInstance((Object)a4t)) continue;
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)namet), (boolean)true);
            String string = containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
            if (EcoreUtil2.isOrIsContainedBy((EObject)a4t, (EObject)container)) {
                TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeContainedBy, (Object)namet, (Object)containerName), (boolean)true);
            }
            return a4t;
        }
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldBeInstanceof, (Object)namet), (boolean)false);
        return null;
    }

    protected <T extends EObject> T shouldExist(String id) {
        EObject i2 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)i2);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)i2);
        return (T)i2;
    }

    protected <T extends EObject> T shouldNotBeTransitioned(String id) {
        EObject a5 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)a5);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a5);
        EObject a5t = this.getAllocatingElement(a5);
        String namet = String.valueOf(name) + "t";
        TransitionTestCase.assertNull((String)NLS.bind((String)Messages.ShouldNotBeTransitioned, (Object)namet), (Object)a5t);
        return (T)a5;
    }

    protected boolean shouldNotBeTransitioned(String id, EClass clazz) {
        EObject a5 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)a5);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)a5);
        String namet = String.valueOf(name) + "t";
        for (EObject a5t : this.getAllocatingElements(a5)) {
            if (!clazz.isInstance((Object)a5t)) continue;
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldNotBeTransitioned, (Object)namet), (boolean)false);
            return false;
        }
        TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldNotBeTransitioned, (Object)namet), (boolean)true);
        return true;
    }

    protected EObject shouldNotBeTransitionedTo(String id, EObject container) {
        EObject lc1 = this.getObject(id);
        String name = EObjectLabelProviderHelper.getText((EObject)lc1);
        TransitionTestCase.assertNotNull((String)NLS.bind((String)Messages.NullElement, (Object)name), (Object)lc1);
        String namet = String.valueOf(name) + "t";
        for (EObject a4t : this.getAllocatingElements(lc1)) {
            String containerName = container instanceof AbstractNamedElement ? ((AbstractNamedElement)container).getName() : container.eClass().getName();
            TransitionTestCase.assertTrue((String)NLS.bind((String)Messages.ShouldNotBeTransitionedInto, (Object)namet, (Object)containerName), (!EcoreUtil2.isOrIsContainedBy((EObject)a4t, (EObject)container) ? 1 : 0) != 0);
        }
        return null;
    }
}

