/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases;

import java.util.Collection;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.data.capellacommon.TransfoLink;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.model.ModelReconciliationCommunicationlinks;

public class ReconciliationCommunicationLinks
extends ModelReconciliationCommunicationlinks {
    public void performTest() throws Exception {
        this.LCPCTransition1();
        this.LCPCTransition2();
        this.LCPCTransition3();
        this.SystemActorTransition();
        this.SystemActorTransition();
    }

    private void SystemActorTransition() {
        this.setPreferenceValue("projection.exchangeItems", Boolean.FALSE);
        this.performActorTransition(this.getObjects(new String[]{SA__ACTORS__A1}));
        Component actor = (Component)this.shouldExist(SA__ACTORS__A1);
        Component logicalActor = (Component)this.shouldExist(LA__LOGICAL_ACTORS__LA1);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"actor.communicationLinks", (Object)"logicalActor.communicationLinks"), (actor.getOwnedCommunicationLinks().size() + 1 == logicalActor.getOwnedCommunicationLinks().size() ? 1 : 0) != 0);
        int nbLinksWithTrace = 0;
        for (CommunicationLink link : logicalActor.getOwnedCommunicationLinks()) {
            if (link.getOutgoingTraces().size() <= 0) continue;
            ++nbLinksWithTrace;
            ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"communicationLink.outgoingTraces", (Object)"1"), (link.getOutgoingTraces().size() == 1 ? 1 : 0) != 0);
            TransfoLink stLink = (TransfoLink)link.getOutgoingTraces().get(0);
            ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"communicationLink.outgoingTraces", (Object)"link"), (boolean)(stLink.getTargetElement() instanceof CommunicationLink));
            CommunicationLink sLink = (CommunicationLink)stLink.getTargetElement();
            ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"communicationLink.kind", (Object)"communicationLink.kind"), (link.getKind() == sLink.getKind() ? 1 : 0) != 0);
            ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"communicationLink.protocol", (Object)"communicationLink.protocol"), (link.getProtocol() == sLink.getProtocol() ? 1 : 0) != 0);
        }
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"nbLinksWithTrace", (Object)"1"), (nbLinksWithTrace == 1 ? 1 : 0) != 0);
    }

    protected void LCPCTransition1() {
        this.setPreferenceValue("projection.exchangeItems", Boolean.FALSE);
        this.performLCtoPCTransition(this.getObjects(new String[]{LA__LC1}));
        Component lc1 = (Component)this.shouldExist(LA__LC1);
        Component pc1 = (Component)this.shouldExist(PA__PC1);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"pc1.senderItems", (Object)"3"), (CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getSenderCommunicationLink((Component)pc1)).size() == 3 ? 1 : 0) != 0);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"pc1.receiverItems", (Object)"3"), (CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getReceiverCommunicationLink((Component)pc1)).size() == 3 ? 1 : 0) != 0);
        ExchangeItem i11 = (ExchangeItem)this.shouldExist(LA__IP1__EI11);
        ExchangeItem i12 = (ExchangeItem)this.shouldExist(LA__IP1__EI12);
        ExchangeItem i13 = (ExchangeItem)this.shouldExist(LA__IP1__EI13);
        ExchangeItem i14 = (ExchangeItem)this.shouldExist(LA__IP1__EI14);
        ExchangeItem i15 = (ExchangeItem)this.shouldExist(LA__IP1__EI15);
        ExchangeItem i16 = (ExchangeItem)this.shouldExist(LA__IP1__EI16);
        ExchangeItem pi11 = (ExchangeItem)this.shouldExist(PA__IP1__EI11);
        ExchangeItem pi12 = (ExchangeItem)this.shouldExist(PA__IP1__EI12);
        Object res = null;
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"PEI1"), (boolean)this.getObject(PA__IP1__EI11).equals(((CommunicationLink)this.getObject(PA__PC1__LINK_TO_EI11)).getExchangeItem()));
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"PEI2"), (boolean)this.getObject(PA__IP1__EI12).equals(((CommunicationLink)this.getObject(PA__PC1__LINK_TO_EI12)).getExchangeItem()));
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"EI3"), (boolean)this.getObject(LA__IP1__EI13).equals(((CommunicationLink)this.getObject(PA__PC1__LINK_TO_EI13)).getExchangeItem()));
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"EI4"), (boolean)this.getObject(LA__IP1__EI14).equals(((CommunicationLink)this.getObject(PA__PC1__LINK_TO_EI14)).getExchangeItem()));
        res = this.mustBeTransitioned(LA__LC1__LINK_TO_EI15);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"EI5"), (boolean)this.getObject(LA__IP1__EI15).equals(((CommunicationLink)res).getExchangeItem()));
        res = this.mustBeTransitioned(LA__LC1__LINK_TO_EI16);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"EI6"), (boolean)this.getObject(LA__IP1__EI16).equals(((CommunicationLink)res).getExchangeItem()));
    }

    protected void LCPCTransition2() {
        this.setPreferenceValue("projection.exchangeItems", Boolean.TRUE);
        this.performLCtoPCTransition(this.getObjects(new String[]{LA__LC1}));
        Component lc1 = (Component)this.shouldExist(LA__LC1);
        Component pc1 = (Component)this.shouldExist(PA__PC1);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"pc1.senderItems", (Object)"3"), (CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getSenderCommunicationLink((Component)pc1)).size() == 3 ? 1 : 0) != 0);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"pc1.receiverItems", (Object)"3"), (CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getReceiverCommunicationLink((Component)pc1)).size() == 3 ? 1 : 0) != 0);
        ExchangeItem i11 = (ExchangeItem)this.shouldExist(LA__IP1__EI11);
        ExchangeItem i12 = (ExchangeItem)this.shouldExist(LA__IP1__EI12);
        ExchangeItem i13 = (ExchangeItem)this.shouldExist(LA__IP1__EI13);
        ExchangeItem i14 = (ExchangeItem)this.shouldExist(LA__IP1__EI14);
        ExchangeItem i15 = (ExchangeItem)this.shouldExist(LA__IP1__EI15);
        ExchangeItem i16 = (ExchangeItem)this.shouldExist(LA__IP1__EI16);
        ExchangeItem pi11 = (ExchangeItem)this.shouldExist(PA__IP1__EI11);
        ExchangeItem pi12 = (ExchangeItem)this.shouldExist(PA__IP1__EI12);
        ExchangeItem pi13 = (ExchangeItem)this.mustBeTransitioned(LA__IP1__EI13);
        ExchangeItem pi14 = (ExchangeItem)this.mustBeTransitioned(LA__IP1__EI14);
        ExchangeItem pi15 = (ExchangeItem)this.mustBeTransitioned(LA__IP1__EI15);
        ExchangeItem pi16 = (ExchangeItem)this.mustBeTransitioned(LA__IP1__EI16);
        Object res = null;
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"PEI1"), (boolean)this.getObject(PA__IP1__EI11).equals(((CommunicationLink)this.getObject(PA__PC1__LINK_TO_EI11)).getExchangeItem()));
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"PEI2"), (boolean)this.getObject(PA__IP1__EI12).equals(((CommunicationLink)this.getObject(PA__PC1__LINK_TO_EI12)).getExchangeItem()));
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"PEI3"), (boolean)pi13.equals(((CommunicationLink)this.getObject(PA__PC1__LINK_TO_EI13)).getExchangeItem()));
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"PEI4"), (boolean)pi14.equals(((CommunicationLink)this.getObject(PA__PC1__LINK_TO_EI14)).getExchangeItem()));
        res = this.mustBeTransitioned(LA__LC1__LINK_TO_EI15);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"PEI5"), (boolean)pi15.equals(((CommunicationLink)res).getExchangeItem()));
        res = this.mustBeTransitioned(LA__LC1__LINK_TO_EI16);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeLinkedTo, (Object)"PC1", (Object)"PEI6"), (boolean)pi16.equals(((CommunicationLink)res).getExchangeItem()));
    }

    protected void LCPCTransition3() {
        this.setPreferenceValue("projection.exchangeItems", Boolean.FALSE);
        this.performLCtoPCTransition(this.getObjects(new String[]{LA__LC2}));
        Component pc1 = (Component)this.mustBeTransitioned(LA__LC1);
        Component pc2 = (Component)this.mustBeTransitioned(LA__LC2);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"pc1.senderItems", (Object)"3"), (CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getSenderCommunicationLink((Component)pc1)).size() == 3 ? 1 : 0) != 0);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"pc2.senderItems", (Object)"1"), (CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getSenderCommunicationLink((Component)pc2)).size() == 1 ? 1 : 0) != 0);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"pc1.receiverItems", (Object)"3"), (CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getReceiverCommunicationLink((Component)pc1)).size() == 3 ? 1 : 0) != 0);
        ReconciliationCommunicationLinks.assertTrue((String)NLS.bind((String)Messages.ShouldBeEqualsTo, (Object)"pc2.receiverItems", (Object)"1"), (CommunicationLinkExt.getExchangeItems((Collection)CommunicationLinkExt.getReceiverCommunicationLink((Component)pc2)).size() == 1 ? 1 : 0) != 0);
    }
}

