/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.i;

import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.test.validation.rules.ju.testcases.i.Rule_I37_38;

public class Rule_I_37_38_FunctionalExchange
extends Rule_I37_38 {
    LogicalFunction lf1;
    LogicalFunction lf2;
    FunctionalExchange fe;
    LogicalFunction libraryRootFunction;
    LogicalFunction projectRootFunction;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.executeCommand(() -> {
            this.projectRootFunction = (LogicalFunction)BlockArchitectureExt.getRootFunction((BlockArchitecture)this.projectSkeleton.getLogicalArchitecture());
            this.lf1 = LaFactory.eINSTANCE.createLogicalFunction();
            this.lf2 = LaFactory.eINSTANCE.createLogicalFunction();
            this.projectRootFunction.getOwnedFunctions().add((Object)this.lf1);
            this.projectRootFunction.getOwnedFunctions().add((Object)this.lf2);
            this.fe = FunctionalExchangeExt.createFunctionalExchange((ActivityNode)this.lf1, (ActivityNode)this.lf2);
            this.libraryRootFunction = (LogicalFunction)BlockArchitectureExt.getRootFunction((BlockArchitecture)this.librarySkeleton.getLogicalArchitecture());
        });
    }

    public void test() throws Exception {
        this.expectRollback(() -> {
            boolean bl = this.libraryRootFunction.getOwnedFunctions().add((Object)this.lf1);
        }, "'FunctionalExchange 1' cannot reference moved element 'FOP 1' via 'source'");
        this.expectRollback(() -> {
            boolean bl = this.libraryRootFunction.getOwnedFunctions().add((Object)this.lf2);
        }, "'FunctionalExchange 1' cannot reference moved element 'FIP 1' via 'target'");
        this.expectRollback(() -> {
            this.libraryRootFunction.getOwnedFunctions().add((Object)this.lf1);
            this.libraryRootFunction.getOwnedFunctionalExchanges().add((Object)this.fe);
        }, "'FunctionalExchange 1' cannot reference moved element 'FIP 1' via 'target'");
        this.expectRollback(() -> {
            this.libraryRootFunction.getOwnedFunctions().add((Object)this.lf2);
            this.libraryRootFunction.getOwnedFunctionalExchanges().add((Object)this.fe);
        }, "'FunctionalExchange 1' cannot reference moved element 'FOP 1' via 'source'");
        this.expectNoRollback(() -> {
            this.libraryRootFunction.getOwnedFunctions().add((Object)this.lf2);
            this.libraryRootFunction.getOwnedFunctions().add((Object)this.lf1);
            this.libraryRootFunction.getOwnedFunctionalExchanges().add((Object)this.fe);
        });
    }
}

