/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.validation.rules.ju.testcases.i;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.test.validation.rules.ju.testcases.i.Rule_I37_38;

public class Rule_I_37_38_PhysicalLink
extends Rule_I37_38 {
    PhysicalComponent pc1;
    PhysicalComponent pc2;
    PhysicalLink pl;
    PhysicalComponent libraryRootComponent;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.executeCommand(() -> {
            PhysicalComponent rootPC = this.projectSkeleton.getPhysicalArchitecture().getOwnedPhysicalComponent();
            this.pc1 = PaFactory.eINSTANCE.createPhysicalComponent();
            rootPC.getOwnedPhysicalComponents().add((Object)this.pc1);
            CapellaElementExt.creationService((EObject)this.pc1);
            PhysicalPort pp1 = CsFactory.eINSTANCE.createPhysicalPort();
            this.pc1.getOwnedFeatures().add((Object)pp1);
            CapellaElementExt.creationService((EObject)pp1);
            this.pc2 = PaFactory.eINSTANCE.createPhysicalComponent();
            rootPC.getOwnedPhysicalComponents().add((Object)this.pc2);
            CapellaElementExt.creationService((EObject)this.pc2);
            PhysicalPort pp2 = CsFactory.eINSTANCE.createPhysicalPort();
            this.pc2.getOwnedFeatures().add((Object)pp2);
            CapellaElementExt.creationService((EObject)pp2);
            this.pl = CsFactory.eINSTANCE.createPhysicalLink();
            rootPC.getOwnedPhysicalLinks().add((Object)this.pl);
            CapellaElementExt.creationService((EObject)this.pl);
            this.pl.getLinkEnds().add((Object)pp1);
            this.pl.getLinkEnds().add((Object)pp2);
            this.libraryRootComponent = this.librarySkeleton.getPhysicalArchitecture().getOwnedPhysicalComponent();
        });
    }

    public void test() throws Exception {
        this.expectRollback(() -> this.libraryRootComponent.getOwnedPhysicalComponents().add((Object)this.pc1), "'PL 1' cannot reference moved element 'PP 1' via 'linkEnds'");
        this.expectRollback(() -> this.libraryRootComponent.getOwnedPhysicalComponents().add((Object)this.pc2), "'PL 1' cannot reference moved element 'PP 1' via 'linkEnds'");
        this.expectRollback(() -> {
            this.libraryRootComponent.getOwnedPhysicalComponents().add((Object)this.pc1);
            this.libraryRootComponent.getOwnedPhysicalLinks().add((Object)this.pl);
        }, "'PL 1' cannot reference moved element 'PP 1' via 'linkEnds'");
        this.expectRollback(() -> {
            this.libraryRootComponent.getOwnedPhysicalComponents().add((Object)this.pc2);
            this.libraryRootComponent.getOwnedPhysicalLinks().add((Object)this.pl);
        }, "'PL 1' cannot reference moved element 'PP 1' via 'linkEnds'");
        this.expectNoRollback(() -> {
            this.libraryRootComponent.getOwnedPhysicalComponents().add((Object)this.pc1);
            this.libraryRootComponent.getOwnedPhysicalComponents().add((Object)this.pc2);
            this.libraryRootComponent.getOwnedPhysicalLinks().add((Object)this.pl);
        });
    }
}

