/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.polarsys.capella.common.ui.toolkit.fields.CStringFieldEditor;
import org.polarsys.capella.common.ui.toolkit.fields.MdeFieldEditor;

public abstract class FieldsViewer
extends Viewer {
    private Composite _composite;
    private HashMap<Listener, Integer> _eventListeners;
    private HashMap<Control, Integer> _eventProviders;
    protected ArrayList<FieldEditor> _fields;
    protected boolean _isMultipleSelection;
    private int _style;
    protected int _viewerExpandLevel;

    public FieldsViewer(Composite parent) {
        this(parent, 0);
    }

    public FieldsViewer(Composite parent, boolean isMultipleSelection) {
        this(parent, isMultipleSelection, 0, -1);
    }

    public FieldsViewer(Composite parent, boolean isMultipleSelection, int style, int viewerExpandLevel) {
        this._isMultipleSelection = isMultipleSelection;
        this._viewerExpandLevel = viewerExpandLevel;
        this.initialize(parent, style);
    }

    public FieldsViewer(Composite parent, DialogPage page) {
        this(parent, 0);
        this.setPage(page);
    }

    public FieldsViewer(Composite parent, int style) {
        this.initialize(parent, style);
    }

    protected void createControl(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FieldsViewer.this.dispose();
            }
        });
    }

    protected Composite createInternalComposite(Composite parent) {
        return new Composite(parent, 0);
    }

    public void dispose() {
        if (this._fields != null) {
            for (FieldEditor fieldEditor : this._fields) {
                fieldEditor.dispose();
            }
            this._fields.clear();
            this._fields = null;
        }
        if (this._eventListeners != null) {
            this._eventListeners.clear();
            this._eventListeners = null;
        }
        if (this._eventProviders != null) {
            this._eventProviders.clear();
            this._eventProviders = null;
        }
    }

    public Composite getControl() {
        return this._composite;
    }

    public HashMap<Listener, Integer> getEventListeners(int eventType) {
        return this._eventListeners;
    }

    public HashMap<Control, Integer> getEventProviders(int eventType) {
        return this._eventProviders;
    }

    public List<FieldEditor> getFields() {
        return this._fields;
    }

    public abstract Object getInput();

    public ISelection getSelection() {
        return null;
    }

    protected int getStyle() {
        return this._style;
    }

    public void handleEvents(int eventTypes, Listener control) {
        this._eventListeners.put(control, eventTypes);
    }

    protected void initialize(Composite parent, int style) {
        this._fields = new ArrayList(0);
        this._style = style;
        this._composite = this.createInternalComposite(parent);
        this.createControl(this._composite);
    }

    public void load() {
        for (FieldEditor field : this._fields) {
            field.load();
        }
    }

    public void propagateEvents(int eventTypes, Control control) {
        this._eventProviders.put(control, eventTypes);
    }

    public void refresh() {
        for (FieldEditor field : this._fields) {
            field.load();
        }
    }

    public void registerField(FieldEditor field) {
        if (!this._fields.contains(field)) {
            this._fields.add(field);
        }
    }

    public void setEnabled(boolean enabled) {
        for (FieldEditor field : this._fields) {
            if (field instanceof CStringFieldEditor) {
                CStringFieldEditor cstField = (CStringFieldEditor)field;
                cstField.getTextControl().setEditable(enabled);
                continue;
            }
            if (field instanceof MdeFieldEditor) {
                MdeFieldEditor mdeField = (MdeFieldEditor)field;
                mdeField.setEnabled(enabled);
                continue;
            }
            field.setEnabled(enabled, this.getControl());
        }
    }

    public abstract void setInput(Object var1);

    public void setPage(DialogPage page) {
        for (FieldEditor field : this._fields) {
            field.setPage(page);
            if (!(page instanceof IPropertyChangeListener)) continue;
            field.setPropertyChangeListener((IPropertyChangeListener)page);
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void setStore(IPreferenceStore store) {
        for (FieldEditor field : this._fields) {
            field.setPreferenceStore(store);
        }
    }

    public void store() {
        for (FieldEditor field : this._fields) {
            field.store();
        }
    }

    public void unregisterField(FieldEditor field) {
        if (this._fields.contains(field)) {
            this._fields.remove(field);
            field.setPropertyChangeListener(null);
        }
    }
}

