/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.polarsys.capella.common.ui.services.helper.AdapterManagerHelper;
import org.polarsys.capella.common.ui.toolkit.viewers.ITreeContentAdapter;
import org.polarsys.capella.common.ui.toolkit.viewers.data.AbstractData;

public class TreeData
extends AbstractData {
    Map<Object, Collection<Object>> _childrenForRootElements;

    public TreeData(Collection<? extends Object> displayedElements, Object context) {
        super(displayedElements, context);
        if (this._childrenForRootElements == null) {
            this._childrenForRootElements = new HashMap<Object, Collection<Object>>(0);
        }
    }

    @Override
    public void addElement(Object element) {
        Object currentElement;
        Object parent;
        if (this._childrenForRootElements == null) {
            this._childrenForRootElements = new HashMap<Object, Collection<Object>>(0);
        }
        if ((parent = this.doGetParent(currentElement = element)) == null) {
            super.addElement(currentElement);
            return;
        }
        do {
            Collection<Object> children = this._childrenForRootElements.get(parent);
            boolean shouldRecurseToBuildParentHierarchy = false;
            if (children == null) {
                children = this.createChildrenCollection();
                this._childrenForRootElements.put(parent, children);
                shouldRecurseToBuildParentHierarchy = true;
            }
            children.add(currentElement);
            if (shouldRecurseToBuildParentHierarchy) {
                currentElement = parent;
                if ((parent = this.doGetParent(currentElement)) != null) continue;
                super.addElement(currentElement);
                continue;
            }
            parent = null;
        } while (parent != null);
    }

    @Override
    public void clearData() {
        super.clearData();
        this._childrenForRootElements.clear();
    }

    protected Collection<Object> createChildrenCollection() {
        return new HashSet<Object>(1);
    }

    protected Object doGetParent(Object element) {
        IEditingDomainItemProvider provider;
        Object parent = null;
        if (!(element instanceof EObject)) {
            return parent;
        }
        EObject elt = (EObject)element;
        ITreeContentAdapter linkSelectionAdapter = null;
        Object context = this.getContext();
        if (context != null) {
            linkSelectionAdapter = (ITreeContentAdapter)AdapterManagerHelper.getAdapter(elt.eClass(), ITreeContentAdapter.class);
        }
        parent = linkSelectionAdapter != null ? linkSelectionAdapter.getParent(elt, context == UNDEFINED_CONTEXT ? null : context) : ((provider = this.getItemProvider(elt)) != null ? provider.getParent((Object)elt) : elt.eContainer());
        return parent != null ? this.filterComputedParent(parent, element) : null;
    }

    protected Object filterComputedParent(Object parent, Object element) {
        if (parent instanceof Resource) {
            return null;
        }
        return parent;
    }

    @Override
    public Object[] getChildren(Object element) {
        Object[] result = NO_CHILD;
        Collection<Object> children = this._childrenForRootElements.get(element);
        if (children != null && !children.isEmpty()) {
            result = children.toArray();
        }
        return result;
    }

    private IEditingDomainItemProvider getItemProvider(EObject element) {
        IEditingDomainItemProvider result = null;
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)element);
        if (editingDomain != null) {
            result = (IEditingDomainItemProvider)editingDomain.getAdapterFactory().adapt((Notifier)element, IEditingDomainItemProvider.class);
        }
        return result;
    }

    @Override
    public Object getParent(Object element) {
        Object result = null;
        for (Map.Entry<Object, Collection<Object>> entry : this._childrenForRootElements.entrySet()) {
            if (!entry.getValue().contains(element)) continue;
            result = entry.getKey();
            break;
        }
        return result;
    }

    @Override
    public void removeAllElements(Object[] elements) {
        super.removeAllElements(elements);
        if (this.getValidElements().isEmpty()) {
            this.clearData();
        }
    }

    @Override
    public void removeElement(Object element) {
        super.removeElement(element);
        Collection<Object> childrenForElement = this._childrenForRootElements.get(element);
        if (childrenForElement != null) {
            if (childrenForElement.isEmpty()) {
                this._childrenForRootElements.remove(element);
            } else {
                return;
            }
        }
        HashSet<Map.Entry<Object, Collection<Object>>> entrySet = new HashSet<Map.Entry<Object, Collection<Object>>>(this._childrenForRootElements.entrySet());
        Iterator iterator = entrySet.iterator();
        HashSet removedNodes = new HashSet(0);
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Collection values = (Collection)entry.getValue();
            if (!values.remove(element)) continue;
            Object parent = entry.getKey();
            if (!values.isEmpty() || this.isValid(parent)) continue;
            removedNodes.add(parent);
            iterator.remove();
        }
        for (Object removedNode : removedNodes) {
            this.removeElement(removedNode);
        }
    }
}

