/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.FilteredModelScope;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ModellerSemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.MultiStorageChoiceDialog;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.Allocation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyValue;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.AssociationPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class CapellaRuleProvider
extends ModellerSemanticRuleProvider {
    private final Map<EClass, IReferenceLocation> perTypeLocations = new HashMap<EClass, IReferenceLocation>();
    private final Collection<IReferenceLocation> predefinedLocations = new HashSet<IReferenceLocation>();
    protected static final List<EReference> NON_DEPENDENCY_REFERENCES = Arrays.asList(ModellingcorePackage.eINSTANCE.getAbstractType_AbstractTypedElements(), CapellacorePackage.eINSTANCE.getType_TypedElements());

    public void adjustScope(FilteredModelScope scope, boolean extend) {
        boolean changed;
        while (changed = this.adjustScopeNonRec(scope, extend)) {
        }
    }

    private boolean adjustScopeNonRec(FilteredModelScope scope, boolean extend) {
        return extend ? this.extendScopeNonRec(scope) : this.reduceScopeNonRec(scope);
    }

    public boolean appliesTo(Object context) {
        boolean result = context instanceof CapellaElement;
        if (!result) {
            Resource resource = null;
            if (context instanceof Resource) {
                resource = (Resource)context;
            } else if (context instanceof EObject) {
                resource = ((EObject)context).eResource();
            }
            result = CapellaResourceHelper.isCapellaResource((Resource)resource);
        }
        return result;
    }

    private EObject deriveLinkContainer(EObject source, EObject target) {
        EObject result = null;
        EObject sourceElement = this.getLinkDerivationReferenceElement(source);
        EObject targetElement = this.getLinkDerivationReferenceElement(target);
        if (sourceElement != null && targetElement != null) {
            result = ModelsUtil.getCommonAncestor((EObject)sourceElement, (EObject)targetElement);
        }
        return result;
    }

    public boolean deriveOwnership(EObject element, Object context) {
        boolean result = super.deriveOwnership(element, context);
        if (!result) {
            ActivityEdge casted;
            EObject container = null;
            EReference containment = null;
            if (element instanceof ActivityEdge) {
                casted = (ActivityEdge)element;
                if (casted.getSource() != null && casted.getTarget() != null && (container = this.deriveLinkContainer((EObject)casted.getSource(), (EObject)casted.getTarget())) instanceof AbstractFunction) {
                    containment = FaPackage.eINSTANCE.getAbstractFunction_OwnedFunctionalExchanges();
                }
            } else if (element instanceof ComponentExchange) {
                casted = (ComponentExchange)element;
                container = this.deriveLinkContainer((EObject)casted.getSource(), (EObject)casted.getTarget());
                if (container instanceof Component) {
                    containment = FaPackage.eINSTANCE.getAbstractFunctionalBlock_OwnedComponentExchanges();
                }
            } else if (element instanceof PhysicalLink) {
                PhysicalLink exchange = (PhysicalLink)element;
                EList ends = exchange.getLinkEnds();
                if (2 == ends.size() && (container = this.deriveLinkContainer((EObject)ends.get(0), (EObject)ends.get(1))) instanceof Component) {
                    containment = CsPackage.eINSTANCE.getComponent_OwnedPhysicalLinks();
                }
            } else if (element instanceof Association) {
                EObject typeContainer;
                AbstractType type;
                casted = (Association)element;
                FOrderedSet allEndProperties = new FOrderedSet();
                allEndProperties.addAll(casted.getOwnedMembers());
                allEndProperties.addAll(casted.getNavigableMembers());
                if (!allEndProperties.isEmpty() && (type = ((Property)allEndProperties.get(0)).getAbstractType()) != null && (typeContainer = type.eContainer()) instanceof AssociationPkg) {
                    container = typeContainer;
                    containment = InformationPackage.eINSTANCE.getAssociationPkg_OwnedAssociations();
                }
            } else if (element instanceof AbstractType) {
                AbstractTypedElement typedElement;
                List containments;
                casted = (AbstractType)element;
                EList typedElements = Collections.emptyList();
                try {
                    TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)((EObject)context));
                    Resource holdingResource = HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)domain);
                    HoldingResourceHelper.attachToHoldingResource((EObject)casted, (Resource)holdingResource);
                    typedElements = casted.getAbstractTypedElements();
                    holdingResource.getContents().remove((Object)casted);
                }
                catch (Exception domain) {
                    // empty catch block
                }
                if (typedElements.size() == 1 && (containments = this.getReferencesForAddition(container = (typedElement = (AbstractTypedElement)typedElements.get(0)).eContainer(), element.eClass(), true, true)).size() == 1) {
                    containment = (EReference)containments.get(0);
                }
            }
            if (container != null && containment != null) {
                BasicReferenceLocation location = new BasicReferenceLocation(container, containment);
                try {
                    LocationsUtil.add((IReferenceLocation)location, (EObject)element);
                    result = true;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public Boolean enforceOwnership(Collection<? extends EObject> roots, Object context) {
        FOrderedSet derivables = new FOrderedSet();
        for (EObject eObject : roots) {
            if (eObject.eContainer() != null) continue;
            if (this.getOwnershipDerivationLevel(eObject) > 0) {
                derivables.add((Object)eObject);
                continue;
            }
            Boolean success = this.enforceOwnershipByPrompt(eObject, context, true, this.perTypeLocations, this.predefinedLocations);
            if (Boolean.TRUE.equals(success)) continue;
            return success;
        }
        for (EObject eObject : derivables) {
            Boolean success;
            boolean derived = this.deriveOwnership(eObject, context);
            if (derived || Boolean.TRUE.equals(success = this.enforceOwnershipByPrompt(eObject, context, true, this.perTypeLocations, this.predefinedLocations))) continue;
            return success;
        }
        return Boolean.TRUE;
    }

    private Boolean enforceOwnershipByPrompt(EObject element, Object context, boolean allowCancel, Map<EClass, IReferenceLocation> perTypeLocations, Collection<IReferenceLocation> predefinedLocations) {
        Boolean result = Boolean.TRUE;
        boolean done = false;
        IReferenceLocation registeredLocation = perTypeLocations.get(element.eClass());
        if (registeredLocation != null && this.supportsAdditionOf(registeredLocation, element)) {
            LocationsUtil.add((IReferenceLocation)registeredLocation, (EObject)element);
            done = true;
        } else {
            Iterator<IReferenceLocation> it = predefinedLocations.iterator();
            while (it.hasNext() && !done) {
                IReferenceLocation predefinedLocation = it.next();
                if (!this.supportsAdditionOf(predefinedLocation, element)) continue;
                LocationsUtil.add((IReferenceLocation)predefinedLocation, (EObject)element);
                done = true;
            }
        }
        while (!done) {
            EObject container;
            List<EReference> containments;
            IReferenceLocation location = null;
            boolean proceed = true;
            MultiStorageChoiceDialog.MultiStorageKind storageKind = MultiStorageChoiceDialog.MultiStorageKind.CURRENT_ONLY;
            List candidateContainers = this.getPossibleContainersInContext(context, Collections.singleton(element));
            if (candidateContainers.size() == 1 && (containments = this.getReferencesForElementAddition(container = (EObject)candidateContainers.get(0), element, true, true)).size() == 1) {
                EReference containment = containments.get(0);
                location = new BasicReferenceLocation(container, containment);
            }
            if (location == null) {
                MultiStorageChoiceDialog dialog = new MultiStorageChoiceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, candidateContainers, element);
                int answer = dialog.open();
                boolean bl = proceed = answer == 0;
                if (proceed) {
                    location = dialog.getChoice();
                    storageKind = dialog.getStorageKind();
                }
            }
            if (proceed) {
                if (location == null) continue;
                LocationsUtil.add(location, (EObject)element);
                done = true;
                switch (storageKind) {
                    case ALL_SIMILAR: {
                        perTypeLocations.put(element.eClass(), location);
                        break;
                    }
                    case ALL_COMPATIBLE: {
                        predefinedLocations.add(location);
                    }
                }
                continue;
            }
            if (!allowCancel) continue;
            return null;
        }
        return result;
    }

    private List<EReference> getReferencesForElementAddition(EObject element, EObject value, boolean nonErasing, boolean containmentOnly) {
        ArrayList<EReference> result = new ArrayList<EReference>();
        EList candidates = containmentOnly ? element.eClass().getEAllContainments() : element.eClass().getEAllReferences();
        for (EReference candidate : candidates) {
            if (!this.supportsAdditionOf(element, candidate, value, nonErasing)) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableList(result);
    }

    private boolean extendScopeNonRec(FilteredModelScope scope) {
        FOrderedSet toAdd = new FOrderedSet();
        for (EObject root : scope.getContents()) {
            toAdd.addAll(this.getAdditionalRelevantElements(root, (IModelScope)scope));
            TreeIterator it = scope.getAllContents(root);
            while (it.hasNext()) {
                EObject current = (EObject)it.next();
                toAdd.addAll(this.getAdditionalRelevantElements(current, (IModelScope)scope));
            }
        }
        boolean result = false;
        for (EObject rootToAdd : ModelsUtil.getRoots((Collection)toAdd)) {
            if (scope.covers(rootToAdd)) continue;
            scope.add(rootToAdd, true);
            result = true;
        }
        return result;
    }

    private Collection<? extends EObject> getAdditionalRelevantElements(EObject element, IModelScope scope) {
        AbstractTypedElement casted;
        FOrderedSet result = new FOrderedSet();
        if (element instanceof AbstractTypedElement && (casted = (AbstractTypedElement)element).getAbstractType() != null) {
            result.add(casted.getAbstractType());
        }
        if (element instanceof Allocation && (casted = (Allocation)element).getTargetElement() != null) {
            result.add(casted.getTargetElement());
        }
        if (element instanceof Association) {
            casted = (Association)element;
            result.addAll(casted.getNavigableMembers());
        }
        if (element instanceof ActivityNode) {
            casted = (ActivityNode)element;
            for (ActivityEdge incoming : casted.getIncoming()) {
                if (!scope.covers((EObject)incoming.getSource())) continue;
                result.add(incoming);
            }
            for (ActivityEdge outgoing : casted.getOutgoing()) {
                if (!scope.covers((EObject)outgoing.getTarget())) continue;
                result.add(outgoing);
            }
        }
        if (element instanceof ComponentPort) {
            casted = (ComponentPort)element;
            for (AbstractInformationFlow flow : casted.getInformationFlows()) {
                if (!scope.covers((EObject)flow.getSource()) || !scope.covers((EObject)flow.getTarget())) continue;
                result.add(flow);
            }
        }
        if (element instanceof PhysicalPort) {
            casted = (PhysicalPort)element;
            for (PhysicalLink link : casted.getInvolvedLinks()) {
                FOrderedSet remaining = new FOrderedSet((Collection)link.getLinkEnds(), null);
                remaining.remove(casted);
                if (remaining.isEmpty() || !scope.covers((EObject)remaining.get(0))) continue;
                result.add(link);
            }
        }
        if (element instanceof SequenceMessage) {
            casted = (SequenceMessage)element;
            result.add(casted.getSendingEnd());
            result.add(casted.getSendingEnd().getEvent());
            result.add(casted.getReceivingEnd());
            result.add(casted.getReceivingEnd().getEvent());
        }
        if (element instanceof InstanceRole && (casted = (InstanceRole)element).getRepresentedInstance() != null) {
            result.add(casted.getRepresentedInstance());
        }
        return Collections.unmodifiableList(result);
    }

    public List<EStructuralFeature> getDefaultOptionalMergeFeatures() {
        return Collections.singletonList(ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name());
    }

    public Collection<EObject> getElementsToRename(Collection<? extends EObject> elements) {
        Collection<? extends EObject> candidates = Collections.unmodifiableCollection(elements);
        FOrderedSet result = new FOrderedSet(candidates, null);
        if (!candidates.isEmpty() && this.isSingletonComponentDriven(candidates.iterator().next())) {
            for (EObject eObject : candidates) {
                Part part;
                AbstractType type;
                if (!(eObject instanceof Part) || !((type = (part = (Part)eObject).getAbstractType()) instanceof Component) || !result.contains(type)) continue;
                result.remove(eObject);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    private EObject getLinkDerivationReferenceElement(EObject element) {
        ComponentExchangeEnd end;
        Object result = element instanceof ComponentExchangeEnd ? ((end = (ComponentExchangeEnd)element).getPart() != null ? end.getPart() : end.getPort()) : (element instanceof PhysicalLinkEnd ? ((end = (PhysicalLinkEnd)element).getPart() != null ? end.getPart() : end.getPort()) : element);
        return result.eContainer();
    }

    public EAttribute getNameAttribute(EObject element) {
        EAttribute result = element instanceof AbstractNamedElement ? ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name() : super.getNameAttribute(element);
        return result;
    }

    public List<EStructuralFeature> getOptionalMergeFeatures() {
        return Arrays.asList(ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name(), CapellacorePackage.eINSTANCE.getCapellaElement_Description(), CapellacorePackage.eINSTANCE.getCapellaElement_Summary());
    }

    public Collection<EObject> getRootsForPatternInclusion(EObject context) {
        FArrayList result = new FArrayList();
        EObject root = EcoreUtil.getRootContainer((EObject)context);
        if (root instanceof Project) {
            result.addAll(((Project)root).getOwnedModelRoots());
        } else {
            result.add(root);
        }
        return Collections.unmodifiableCollection(result);
    }

    private boolean isMeaningfulWithin(EObject element, IModelScope scope) {
        AbstractTrace casted;
        if (element instanceof EnumerationPropertyValue) {
            return false;
        }
        FOrderedSet mustBeIncluded = new FOrderedSet();
        if (element instanceof AbstractTrace) {
            casted = (AbstractTrace)element;
            mustBeIncluded.add(casted.getSourceElement());
            mustBeIncluded.add(casted.getTargetElement());
        } else if (element instanceof FunctionalExchange) {
            casted = (FunctionalExchange)element;
            mustBeIncluded.add(casted.getSource());
            mustBeIncluded.add(casted.getTarget());
        } else if (element instanceof ComponentExchange) {
            ComponentExchange connection = (ComponentExchange)element;
            InformationsExchanger source = connection.getSource();
            if (source instanceof ComponentExchangeEnd) {
                mustBeIncluded.add(((ComponentExchangeEnd)source).getPart());
                mustBeIncluded.add(((ComponentExchangeEnd)source).getPort());
            } else {
                mustBeIncluded.add(source);
            }
            InformationsExchanger target = connection.getTarget();
            if (target instanceof ComponentExchangeEnd) {
                mustBeIncluded.add(((ComponentExchangeEnd)target).getPart());
                mustBeIncluded.add(((ComponentExchangeEnd)target).getPort());
            } else {
                mustBeIncluded.add(target);
            }
        } else if (element instanceof PhysicalLink) {
            PhysicalLink physicalLink = (PhysicalLink)element;
            for (AbstractPhysicalLinkEnd end : physicalLink.getLinkEnds()) {
                if (end instanceof PhysicalLinkEnd) {
                    mustBeIncluded.add(((PhysicalLinkEnd)end).getPart());
                    mustBeIncluded.add(((PhysicalLinkEnd)end).getPort());
                    continue;
                }
                mustBeIncluded.add(end);
            }
        }
        for (EObject current : mustBeIncluded) {
            if (current != null && scope.covers(current)) continue;
            return false;
        }
        return true;
    }

    public boolean isMergeDependency(EObject element) {
        return element instanceof DataType;
    }

    private boolean isSingletonComponentDriven(EObject element) {
        boolean result = false;
        if (element instanceof ModelElement) {
            result = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isSingletonComponentsDriven((EObject)element));
        }
        return result;
    }

    public int getOwnershipDerivationLevel(EObject element) {
        int result = element instanceof PhysicalLink ? 2 : (element instanceof ActivityEdge || element instanceof ComponentExchange || element instanceof Association || element instanceof Component ? 1 : super.getOwnershipDerivationLevel(element));
        return result;
    }

    private boolean reduceScopeNonRec(FilteredModelScope scope) {
        FOrderedSet toDelete = new FOrderedSet();
        for (EObject root : scope.getContents()) {
            TreeIterator it = scope.getAllContents(root);
            while (it.hasNext()) {
                EObject current = (EObject)it.next();
                if (this.isMeaningfulWithin(current, (IModelScope)scope)) continue;
                toDelete.add(current);
                it.prune();
            }
        }
        for (EObject rootToDelete : ModelsUtil.getRoots((Collection)toDelete)) {
            scope.removeFromScope(rootToDelete, true);
        }
        return !toDelete.isEmpty();
    }

    public boolean supportsAdditionOf(EObject element, EReference reference, EObject value, boolean nonErasing) {
        boolean result = super.supportsAdditionOf(element, reference, value, nonErasing);
        if (result && value instanceof Part) {
            Part part = (Part)value;
            Type type = part.getType();
            if (type instanceof SystemComponent) {
                result = element instanceof SystemComponent || element instanceof SystemComponentPkg;
            } else if (type instanceof LogicalComponent) {
                result = element instanceof LogicalComponent || element instanceof LogicalComponentPkg;
            } else if (type instanceof PhysicalComponent) {
                boolean bl = result = element instanceof PhysicalComponent || element instanceof PhysicalComponentPkg;
            }
            if (result && ComponentExt.isActor((EObject)type)) {
                result = element instanceof ComponentPkg || ComponentExt.isActor((EObject)element);
            }
        }
        return result;
    }

    protected boolean supportsAdditionOf(EObject element, EReference reference, EClass valueType, boolean nonErasing) {
        boolean result;
        boolean bl = result = reference != ModellingcorePackage.eINSTANCE.getModelElement_OwnedMigratedElements() && super.supportsAdditionOf(element, reference, valueType, nonErasing);
        if (result) {
            EClass elementClass = element.eClass();
            if (FaPackage.eINSTANCE.getAbstractFunction().isSuperTypeOf(valueType)) {
                if (PaPackage.eINSTANCE.getPhysicalFunction().isSuperTypeOf(valueType)) {
                    result = PaPackage.eINSTANCE.getPhysicalFunction().isSuperTypeOf(elementClass) || PaPackage.eINSTANCE.getPhysicalFunctionPkg().isSuperTypeOf(elementClass);
                } else if (LaPackage.eINSTANCE.getLogicalFunction().isSuperTypeOf(valueType)) {
                    result = LaPackage.eINSTANCE.getLogicalFunction().isSuperTypeOf(elementClass) || LaPackage.eINSTANCE.getLogicalFunctionPkg().isSuperTypeOf(elementClass);
                } else if (CtxPackage.eINSTANCE.getSystemFunction().isSuperTypeOf(valueType)) {
                    result = CtxPackage.eINSTANCE.getSystemFunction().isSuperTypeOf(elementClass) || CtxPackage.eINSTANCE.getSystemFunctionPkg().isSuperTypeOf(elementClass);
                } else if (OaPackage.eINSTANCE.getOperationalActivity().isSuperTypeOf(valueType)) {
                    result = OaPackage.eINSTANCE.getOperationalActivity().isSuperTypeOf(elementClass) || OaPackage.eINSTANCE.getOperationalActivityPkg().isSuperTypeOf(elementClass);
                }
            }
        }
        return result;
    }

    private boolean supportsAdditionOf(IReferenceLocation location, EObject value) {
        return this.supportsAdditionOf(location.getElement(), location.getReference(), value, true);
    }

    public boolean isDependency(EReference reference) {
        return !reference.isDerived() && !NON_DEPENDENCY_REFERENCES.contains(reference);
    }

    public boolean isApplicableTo(EObject obj) {
        return true;
    }

    public boolean canBeAutomaticallyMerged(EObject element) {
        return false;
    }

    public EObject getAutomaticMergeTarget(EObject element, Object targetScope) {
        return null;
    }

    public String getPrefixText(EObject element) {
        return "";
    }

    public void initializeTargetScope(IFeaturedModelScope referenceScope, IFeaturedModelScope targetScope) {
    }

    public boolean isAllowedToBeRoot(EObject obj) {
        return obj instanceof Project;
    }

    public boolean isAutomaticallyUpdatedDiagram(Object diagram) {
        return false;
    }

    public void postPatternApplication(IPatternApplication application, Collection<EObject> additions, Collection<IDifference> merges) {
        if (!additions.isEmpty()) {
            TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)additions.iterator().next());
            HoldingResourceHelper.flushHoldingResource((TransactionalEditingDomain)domain);
        }
    }

    public void reset() {
        this.perTypeLocations.clear();
        this.predefinedLocations.clear();
    }
}

