/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.benchmarks.ju.refreshAllDiagrams;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.polarsys.capella.common.lib.Memory;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.test.benchmarks.ju.testcases.AbstractBenchmarkTestCase;
import org.polarsys.capella.test.benchmarks.ju.utils.MemoryLogger;

public class RefreshAllDiagramsTestCase
extends AbstractBenchmarkTestCase {
    public void test() {
        long usedMemoryBefore = Memory.getUsedMemory() / 0x100000L;
        Session session = this.getSession(this.getRequiredTestModels().get(0));
        Collection representationsToRefresh = DialectManager.INSTANCE.getAllRepresentations(session);
        for (DRepresentation rep : representationsToRefresh) {
            IEditorPart editor = DialectUIManager.INSTANCE.openEditor(session, rep, (IProgressMonitor)new NullProgressMonitor());
            RefreshAllDiagramsTestCase.assertNotNull((String)("Unable to open editor " + RepresentationHelper.getRepresentationDescriptor((DRepresentation)rep)), (Object)editor);
            this.closeEditor(editor);
        }
        long usedMemoryAfter = Memory.getUsedMemory() / 0x100000L;
        System.out.println("Used memory: " + usedMemoryBefore + "MB / " + usedMemoryAfter + "MB.");
        MemoryLogger.getInstance().log(((Object)((Object)this)).getClass().getCanonicalName(), usedMemoryAfter - usedMemoryBefore);
    }

    public void closeEditor(IEditorPart editor) {
        IEditorSite editorSite = editor.getEditorSite();
        RefreshAllDiagramsTestCase.assertNotNull((String)"EditorSite is null", (Object)editorSite);
        IWorkbenchPage page = editorSite.getPage();
        RefreshAllDiagramsTestCase.assertNotNull((String)"WorkbenchPage is null", (Object)page);
        page.closeEditor(editor, false);
    }
}

