/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.commandline.ju.testcases;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.app.IApplicationContext;
import org.polarsys.capella.core.sirius.ui.commandline.ExportRepresentationsCommandLine;
import org.polarsys.capella.test.commandline.ju.utils.MockApplicationContext;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.api.ModelProviderHelper;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class CommandLineExportRepresentationsTest
extends BasicTestCase {
    public void test() {
        IPath workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getRawLocation();
        String projectName = "RefreshRemoveExport";
        File sourceFolder = this.getFolderInTestModelRepository(projectName);
        ModelProviderHelper.getInstance().importCapellaProject(projectName, sourceFolder);
        try {
            this.exportImages(projectName);
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandLineExportRepresentationsTest.assertFalse((String)e.getMessage(), (boolean)true);
        }
        IPath validationResultFile = workspaceLocation.append(projectName).append("ImagesExported").append(projectName).append(String.valueOf(projectName) + ".aird");
        CommandLineExportRepresentationsTest.assertTrue((validationResultFile.toFile().listFiles().length == 3 ? 1 : 0) != 0);
    }

    private void exportImages(String projectName) throws Exception {
        String[] arguments = new String[]{"-appid", "org.polarsys.capella.exportRepresentations", "-input", String.valueOf(projectName) + "/" + projectName + ".aird", "-outputfolder", String.valueOf(projectName) + "/ImagesExported", "-forceoutputfoldercreation"};
        MockApplicationContext mockApplicationContext = new MockApplicationContext(arguments);
        ExportRepresentationsCommandLine commandLine = new ExportRepresentationsCommandLine();
        commandLine.parseContext((IApplicationContext)mockApplicationContext);
        commandLine.checkArgs((IApplicationContext)mockApplicationContext);
        commandLine.prepare((IApplicationContext)mockApplicationContext);
        commandLine.execute((IApplicationContext)mockApplicationContext);
        GuiActions.flushASyncGuiJobs();
    }
}

