/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.CapabilityDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class MissionDiagram
extends CapabilityDiagram {
    public MissionDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(type, context, diagram);
    }

    public static MissionDiagram createDiagram(SessionContext executionContext, String targetIdentifier, String name) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        return (MissionDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new MissionDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static MissionDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (MissionDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new MissionDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    @Deprecated
    public void createCapabilityExploitation(String sourceId, String targetId, String id) {
        new CreateDEdgeTool(this, this.getCapabilityExploitationToolName(), sourceId, targetId, id).run();
    }

    public String createCapabilityExploitation(String sourceId, String targetId) {
        return this.createEdgeElement(sourceId, targetId, this.getCapabilityExploitationToolName());
    }

    public void cannotCreateCapabilityExploitation(String sourceId, String targetId) {
        new CreateDEdgeTool(this, this.getCapabilityExploitationToolName(), sourceId, targetId).shouldFail();
    }

    public String createMission() {
        return this.createNodeElement(this.getDiagramId(), this.getMissionToolName());
    }

    @Deprecated
    public void createMission(String id) {
        new CreateAbstractDNodeTool((DiagramContext)this, this.getMissionToolName(), this.getDiagramId(), id).run();
    }

    public String createMissionInvolvement(String sourceId, String targetId) {
        return this.createEdgeElement(sourceId, targetId, this.getMissionInvolvementToolName());
    }

    public void cannotCreateMissionInvolvement(String sourceId, String targetId) {
        new CreateDEdgeTool(this, this.getMissionInvolvementToolName(), sourceId, targetId).shouldFail();
    }

    public boolean canInsertMission() {
        if (this.isA("Missions Capabilities Blank")) {
            return true;
        }
        return this.isA("Missions Blank");
    }

    public void insertMission(String id) {
        new InsertRemoveTool((DiagramContext)this, this.getMissionsToolName(), this.getDiagramId()).insert(id);
    }

    public void removeMission(String id) {
        new InsertRemoveTool((DiagramContext)this, this.getMissionsToolName(), this.getDiagramId()).remove(id);
    }

    private String getMissionToolName() {
        String name = null;
        if (this.isA("Missions Capabilities Blank")) {
            name = "mission";
        } else if (this.isA("Missions Blank")) {
            name = "mission";
        } else if (this.isA("Contextual Capability")) {
            name = "mission";
        }
        return name;
    }

    private String getMissionsToolName() {
        String name = null;
        if (this.isA("Missions Capabilities Blank")) {
            name = "missions";
        } else if (this.isA("Missions Blank")) {
            name = "missions";
        } else if (this.isA("Contextual Capability")) {
            name = "missions";
        }
        return name;
    }

    private String getCapabilityExploitationToolName() {
        String name = null;
        if (this.isA("Missions Capabilities Blank")) {
            name = "capability.exploitation";
        } else if (this.isA("Missions Blank")) {
            name = "capability.exploitation";
        } else if (this.isA("Contextual Capability")) {
            name = "capability.exploitation";
        } else if (this.isA("Contextual Mission")) {
            name = "capability.exploitation";
        }
        return name;
    }

    private String getMissionInvolvementToolName() {
        String name = null;
        if (this.isA("Missions Capabilities Blank")) {
            name = "involved.actor";
        } else if (this.isA("Missions Blank")) {
            name = "actor.involvement";
        } else if (this.isA("Contextual Mission")) {
            name = "actor.involvement";
        }
        return name;
    }
}

