/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.EABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.OABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreatePathTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InitializationFromExistingDiagramTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.ReconnectTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.SelectFromListTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.SwitchTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.xab.ReuseComponentTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XABDiagram
extends CommonDiagram {
    BlockArchitectureExt.Type type = null;

    public XABDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static XABDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        switch (type) {
            case OA: {
                return OABDiagram.createDiagram(executionContext, targetIdentifier);
            }
            case EPBS: {
                return EABDiagram.createDiagram(executionContext, targetIdentifier);
            }
            case PA: {
                return PABDiagram.createDiagram(executionContext, targetIdentifier);
            }
            case SA: {
                name = "System Architecture Blank";
                break;
            }
            case LA: {
                name = "Logical Architecture Blank";
            }
        }
        return (XABDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new XABDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static XABDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (XABDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new XABDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public String createActor(String id) {
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, this.getCreateActorToolName(), this.getDiagramId(), id).run();
        Assert.assertTrue((boolean)this.getCreatedComponent(element).isActor());
        return ((CapellaElement)element.getTarget()).getId();
    }

    public String createActor(String id, String containerId) {
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, this.getCreateActorToolName(), containerId, id).run();
        Assert.assertTrue((boolean)this.getCreatedComponent(element).isActor());
        return ((CapellaElement)element.getTarget()).getId();
    }

    public void cannotCreateActor(String id, String containerId) {
        new CreateContainerTool((DiagramContext)this, this.getCreateActorToolName(), containerId, id).cannotRun();
    }

    public void failedPreconditionCreateActor(String id, String containerId) {
        new CreateContainerTool((DiagramContext)this, this.getCreateActorToolName(), containerId, id).shouldFail();
    }

    protected Component getCreatedComponent(DDiagramElementContainer element) {
        Component component = null;
        CapellaElement target = (CapellaElement)element.getTarget();
        if (target instanceof Part) {
            Part actorPart = (Part)element.getTarget();
            component = (Component)actorPart.getAbstractType();
        } else {
            component = (Component)target;
        }
        return component;
    }

    protected String getCreateActorToolName() {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "operational.actor";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "actor";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "logical.actor";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "physical.actor";
        }
        return name;
    }

    public String createFunction(String id, String containerId) {
        DNode element = (DNode)new CreateNodeTool((DiagramContext)this, "function", containerId, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public void createFunction(String id, String containerId, BlockArchitectureExt.FunctionType functionType) {
        String name = null;
        switch (functionType) {
            case SYSTEM_FUNCTION: {
                name = "function";
                break;
            }
            case DUPLICATE: {
                name = "duplicate";
                break;
            }
            case GATHER: {
                name = "gather";
                break;
            }
            case ROUTE: {
                name = "route";
                break;
            }
            case SELECT: {
                name = "select";
                break;
            }
            case SPLIT: {
                name = "split";
                break;
            }
        }
        new CreateNodeTool((DiagramContext)this, name, containerId, id).run();
    }

    public String getToolNameShowHideActor() {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "operational.entities" : (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)this.getDiagramDescriptor().getTarget())) ? "actors.multipart" : "actors.monopart");
        return name;
    }

    public void initializationFromExistingDiagram(DiagramContext existingContext) {
        InitializationFromExistingDiagramTool tool = new InitializationFromExistingDiagramTool((DiagramContext)this, "initialization.from.existing.diagram", existingContext);
        tool.setTolerance(6);
        tool.insert(existingContext.getDiagramId());
    }

    public void insertActor(String id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameShowHideActor()).insert(id);
    }

    public void removeActor(String id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameShowHideActor()).remove(id);
    }

    public void insertActor(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameShowHideActor(), containerId).insert(id);
    }

    public void removeActor(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameShowHideActor(), containerId).remove(id);
    }

    public void insertComponent(String id) {
        this.insertComponent(id, this.getDiagramId());
    }

    public void insertComponent(String toInsertId, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "operational.entities";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)this.getDiagramDescriptor().getTarget())) ? "components.multipart" : "components.monopart";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insert(toInsertId);
    }

    public void removeComponent(String id) {
        this.removeComponent(id, this.getDiagramId());
    }

    public void removeComponent(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "operational.entities";
            new InsertRemoveTool((DiagramContext)this, name).remove(id);
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            if (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)this.getDiagramDescriptor().getTarget()))) {
                new InsertRemoveTool((DiagramContext)this, new String[]{"components.multipart", "components"}, containerId).remove(id);
            } else {
                new InsertRemoveTool((DiagramContext)this, new String[]{"components.monopart", "components"}, containerId).remove(id);
            }
        }
    }

    public String createComponent(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "operational.entity";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "logical.component";
        }
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, name, containerId, id).run();
        Assert.assertFalse((boolean)this.getCreatedComponent(element).isActor());
        return ((CapellaElement)element.getTarget()).getId();
    }

    public void cannotCreateComponent(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "operational.entity";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "logical.component";
        }
        new CreateContainerTool((DiagramContext)this, name, containerId, id).cannotRun();
    }

    public void createComponentExchange(String idSource, String idTarget, String id) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "communication.mean";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "component.exchange.with.ports";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "component.exchange";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "component.exchange";
        }
        new CreateDEdgeTool(this, name, idSource, idTarget, id).run();
    }

    public void createComponentExchangeDelegation(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "delegation", idSource, idTarget, id).run();
    }

    public void createComponentExchangeWithDelegation(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "component.exchange.with.delegations", idSource, idTarget, id).run();
    }

    public void createComponentExchangeWithPorts(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "component.exchange.with.ports", idSource, idTarget, id).run();
    }

    public void createComponentExchangeWithoutPorts(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "component.exchange.without.ports", idSource, idTarget, id).run();
    }

    public void createComponentExchangeBetweenTypes(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "component.exchange.between.types", idSource, idTarget, id).run();
    }

    public String getToolNameReconnectComponentExchange(BlockArchitectureExt.LinkDirection direction) {
        String name = null;
        if (direction == BlockArchitectureExt.LinkDirection.SOURCE) {
            if (this.type == BlockArchitectureExt.Type.OA) {
                name = "Source Communication Mean";
            } else if (this.type == BlockArchitectureExt.Type.SA) {
                name = "CA Reconnect Exchanges Source";
            } else if (this.type == BlockArchitectureExt.Type.LA) {
                name = "Reconnect Connection Source";
            } else if (this.type == BlockArchitectureExt.Type.PA) {
                name = "Reconnect ComponentExchange Source";
            }
        } else if (direction == BlockArchitectureExt.LinkDirection.TARGET) {
            if (this.type == BlockArchitectureExt.Type.OA) {
                name = "Target Communication Mean";
            } else if (this.type == BlockArchitectureExt.Type.SA) {
                name = "CA Reconnect Exchanges Target";
            } else if (this.type == BlockArchitectureExt.Type.LA) {
                name = "Reconnect Connection Target";
            } else if (this.type == BlockArchitectureExt.Type.PA) {
                name = "Reconnect ComponentExchange Target";
            }
        }
        return name;
    }

    public void reconnectComponentExchange(String id, String oldTargetId, String newTargetId, BlockArchitectureExt.LinkDirection direction) {
        new ReconnectTool(this, this.getToolNameReconnectComponentExchange(direction), id, oldTargetId, newTargetId).run();
    }

    public void cannotReconnectComponentExchange(String id, String oldTargetId, String newTargetId, BlockArchitectureExt.LinkDirection direction) {
        new ReconnectTool(this, this.getToolNameReconnectComponentExchange(direction), id, oldTargetId, newTargetId).shouldFail();
    }

    public void createFunctionalExchange(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "functional.exchange", idSource, idTarget, id).run();
    }

    public void createPhysicalLink(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "physical.link", idSource, idTarget, id).run();
    }

    public void cannotCreatePhysicalLink(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, "physical.link", idSource, idTarget, id).cannotRun();
    }

    public String getToolNameReconnectPhysicalLink(BlockArchitectureExt.LinkDirection direction) {
        String name = null;
        if (direction == BlockArchitectureExt.LinkDirection.SOURCE) {
            name = "Reconnect PhysicalLink Source";
        } else if (direction == BlockArchitectureExt.LinkDirection.TARGET) {
            name = "Reconnect PhysicalLink Target";
        }
        return name;
    }

    public void reconnectPhysicalLink(String id, String oldTargetId, String newTargetId, BlockArchitectureExt.LinkDirection direction) {
        new ReconnectTool(this, this.getToolNameReconnectPhysicalLink(direction), id, oldTargetId, newTargetId).run();
    }

    public void cannotReconnectPhysicalLink(String id, String oldTargetId, String newTargetId, BlockArchitectureExt.LinkDirection direction) {
        new ReconnectTool(this, this.getToolNameReconnectPhysicalLink(direction), id, oldTargetId, newTargetId).shouldFail();
    }

    public void insertComponentExchange(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "communication.means";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "component.exchanges";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "component.exchanges.delegations";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "component.exchanges.delegations";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).insert(id);
    }

    public void removeComponentExchange(String id, String containerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "communication.means";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "component.exchanges";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "component.exchanges.delegations";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "component.exchanges.delegations";
        }
        new InsertRemoveTool((DiagramContext)this, name, containerId).remove(id);
    }

    public void insertPhysicalLink(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "physical.links", containerId).insert(id);
    }

    public void removePhysicalLink(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "physical.links", containerId).remove(id);
    }

    public String getToolNameManageAllocatedFunction() {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "manage.activity.allocation" : "manage.function.allocation";
        return name;
    }

    public void manageAllocatedFunction(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameManageAllocatedFunction(), containerId).insert(id);
    }

    public void manageAllocatedFunctionRemove(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameManageAllocatedFunction(), containerId).remove(id);
    }

    public void dragAndDropAbstractFunctionallocation(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DnD AB AbstractFunction Allocation");
    }

    public void dragAndDropComponentPort(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DnD AB ComponentPort");
    }

    public void dragAndDropFunctionPort(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DnD AB FunctionPort");
    }

    public void dragAndDropFunctionAllocationFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Function Allocation From Project Explorer");
    }

    public void dragAndDropPhysicalPort(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "D&D PhysicalPort");
    }

    public String dragAndDropComponentsFromExplorer(String idDraggedElement, String containerId) {
        return this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Components From Project Explorer");
    }

    public void dragAndDropComponent(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, this.getDragAndDropComponentToolName());
    }

    public void dragAndDropShouldFail(String sourceId, String targetId) {
        try {
            this.dragAndDropComponent(sourceId, targetId);
            Assert.fail((String)("Drag and drop should have failed for diagram: " + this + " source " + sourceId + " target " + targetId));
        }
        catch (AssertionError error) {
            Assert.assertTrue((boolean)((Throwable)((Object)error)).getMessage().startsWith("Precondition"));
        }
    }

    public void dragAndDropShouldSucceed(String sourceId, String targetId) {
        this.dragAndDropComponent(sourceId, targetId);
    }

    private String getDragAndDropComponentToolName() {
        if (this.type == BlockArchitectureExt.Type.OA) {
            return "DnD Entitiy";
        }
        return "DnD AB Component";
    }

    private String getToolNameShowHideAllocatedFunction() {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "allocated.activities";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "allocated.functions";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "allocated.functions";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "allocated.functions";
        }
        return name;
    }

    public void insertAllocatedFunction(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameShowHideAllocatedFunction(), containerId).insert(id);
    }

    public void removeAllocatedFunction(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameShowHideAllocatedFunction(), containerId).remove(id);
    }

    private String getToolNameALLAllocatedFunction(String ... types) {
        String name = null;
        String[] aTypes = types;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = aTypes.length > 0 ? aTypes[0] : "all.allocated.activities.in.entities";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "all.allocated.functions";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "all.allocated.functions";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "all.allocated.functions";
        }
        return name;
    }

    public void insertAllAllocatedFunction(String id, String containerId, String ... types) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameALLAllocatedFunction(types), containerId).insert(id);
    }

    public void removeAllAllocatedFunction(String id, String containerId, String ... types) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameALLAllocatedFunction(types), containerId).remove(id);
    }

    @Override
    public Collection<EObject> adaptTool(AbstractToolStep<?> tool, Map<String, Object> parameters, Collection<EObject> semanticElements) {
        Collection scope = AbstractExternalJavaAction.getScope(parameters);
        if (scope.isEmpty()) {
            return semanticElements;
        }
        EObject scopeElement = (EObject)scope.iterator().next();
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject element : semanticElements) {
            if (element instanceof Part && scopeElement instanceof Component) {
                result.add((EObject)((Part)element).getAbstractType());
                continue;
            }
            if (element instanceof Component && scopeElement instanceof Part) {
                result.add((EObject)((Component)element).getRepresentingParts().get(0));
                continue;
            }
            result.add(element);
        }
        return result;
    }

    public String getNameFunctionalExchange() {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.SA) {
            name = "functional.exchanges";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "functional.exchanges";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "functional.exchanges";
        }
        return name;
    }

    public void insertFunctionalExchange(String id, String containerId, boolean autoRefresh) {
        new InsertRemoveTool(this, this.getNameFunctionalExchange(), containerId, autoRefresh).insert(id);
    }

    public void removeFunctionalExchange(String id, String containerId, boolean autoRefresh) {
        new InsertRemoveTool(this, this.getNameFunctionalExchange(), containerId, autoRefresh).remove(id);
    }

    public String getToolNameReconnectFunctionalExchange() {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "OAIB Reconnect Exchanges";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            name = "SAB Reconnect Function Exchanges";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "LAB Reconnect Function Exchanges";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "PAB Reconnect Function Exchanges";
        }
        return name;
    }

    public void reconnectFunctionalExchange(String id, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getToolNameReconnectFunctionalExchange(), id, oldTargetId, newTargetId).run();
    }

    public void cannotReconnectFunctionalExchange(String id, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getToolNameReconnectFunctionalExchange(), id, oldTargetId, newTargetId).shouldFail();
    }

    public PhysicalPath createPhysicalPath(String path, String ... links) {
        return (PhysicalPath)((DEdge)new CreatePathTool(this, "physical.path", path, links).run()).getTarget();
    }

    public void insertPhysicalPath(String ... path) {
        new InsertRemoveTool((DiagramContext)this, "physical.paths").insert(path);
    }

    public void removePhysicalPath(String ... path) {
        new InsertRemoveTool((DiagramContext)this, "physical.paths").remove(path);
    }

    public void createFunctionalChain(String path, String ... links) {
        new CreatePathTool(this, "functional.chain", path, links).run();
    }

    public String getToolNameFunctionalChains() {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "operational.processes" : "functional.chains";
        return name;
    }

    public void insertFunctionalChain(String id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameFunctionalChains(), this.getDiagramId()).insert(id);
    }

    public void removeFunctionalChain(String id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameFunctionalChains(), this.getDiagramId()).remove(id);
    }

    public void createFunctionPort(String id, BlockArchitectureExt.FunctionPortType fpType, String containerId) {
        String name = null;
        switch (fpType) {
            case IN_FUNCTION_PORT: {
                name = "input.port";
                break;
            }
            case OUT_FUNCTION_PORT: {
                name = "output.port";
            }
        }
        new CreateAbstractDNodeTool((DiagramContext)this, name, containerId, id).run();
    }

    public void createComponentPort(String id, BlockArchitectureExt.ComponentPortType cpType, String containerId) {
        String name = null;
        switch (cpType) {
            case IN_FLOW_PORT: {
                name = "in.flow.port";
                break;
            }
            case OUT_FLOW_PORT: {
                name = "out.flow.port";
                break;
            }
            case IN_OUT_FLOW_PORT: {
                name = "in.out.flow.port";
                break;
            }
            case STANDARD_PORT: {
                name = "standard.port";
                break;
            }
        }
        new CreateAbstractDNodeTool((DiagramContext)this, name, containerId, id).run();
    }

    public void createPhysicalPort(String id, String containerId) {
        new CreateAbstractDNodeTool((DiagramContext)this, "physical.port", containerId, id).run();
    }

    public void createPortAllocation(String sourceId, String targetId) {
        new CreateDEdgeTool(this, "port.allocation", sourceId, targetId).run();
    }

    public void removePortAllocation(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "port.allocations", containerId).insert(id);
    }

    public void insertPortAllocation(String containerId, String id) {
        new InsertRemoveTool((DiagramContext)this, "port.allocations", containerId).remove(id);
    }

    public void selectElementsFromModesAndStates(String[] selectedModeAndStates, String ... inserted) {
        String name = null;
        name = this.type == BlockArchitectureExt.Type.OA ? "activities.from.mode.state" : "functions.from.mode.state";
        new SelectFromListTool((DiagramContext)this, name, this.getDiagramId(), inserted).select(selectedModeAndStates);
    }

    public void selectElementsFromScenario(String[] selectedScenarioIds, String ... inserted) {
        new SelectFromListTool((DiagramContext)this, "elements.from.scenario", this.getDiagramId(), inserted).select(selectedScenarioIds);
    }

    private String getToolNameShowHidePorts() {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.SA) {
            name = "component.ports";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "ports";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "behaviour.ports";
        }
        return name;
    }

    public void insertPort(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameShowHidePorts(), containerId).insert(id);
    }

    public void removePort(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getToolNameShowHidePorts(), containerId).remove(id);
    }

    public void insertFunctionPort(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "function.ports", containerId).insert(id);
    }

    public void removeFunctionPort(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "function.ports", containerId).remove(id);
    }

    public void insertCategory(String id, String containerId) {
        new SelectFromListTool((DiagramContext)this, "categories", containerId, id).select(id);
    }

    public void removeCategory(String id, String containerId) {
        new SelectFromListTool((DiagramContext)this, "categories", containerId, new String[0]).select(id);
    }

    public void switchComponentExchangesCategories(String id, boolean addCategory) {
        if (addCategory) {
            new SwitchTool(this, "switch.component.exchanges.categories").insert(id);
        } else {
            new SwitchTool(this, "switch.component.exchanges.categories").remove(id);
        }
    }

    public void switchPhysicalLinksCategories(String id, boolean addCategory) {
        if (addCategory) {
            new SwitchTool(this, "switch.physical.links.categories").insert(id);
        } else {
            new SwitchTool(this, "switch.physical.links.categories").remove(id);
        }
    }

    public void switchFunctionalExchangesCategories(String id, boolean addCategory) {
        if (addCategory) {
            new SwitchTool(this, "switch.functional.exchanges.categories").insert(id);
        } else {
            new SwitchTool(this, "switch.functional.exchanges.categories").remove(id);
        }
    }

    public void reuseComponent(String containerId, String ... ids) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.LA) {
            name = "reuse.logical.component";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "reuse.behaviour.pc";
        }
        new ReuseComponentTool(this, name, containerId).select(ids);
    }

    public void reuseActor(String containerId, String ... ids) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.SA) {
            name = "reuse.actor";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "reuse.logical.actor";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "reuse.physical.actor";
        }
        new ReuseComponentTool(this, name, containerId).select(ids);
    }

    @Override
    public void hasntView(String identifier) {
        super.hasntView(identifier);
        this.checkContainedElements(identifier);
    }

    public void checkContainedElements(String id) {
        Part partSem;
        EObject semantic = this.getSessionContext().getSemanticElement(id);
        if (semantic != null && semantic instanceof Part && (partSem = (Part)semantic).getAbstractType() instanceof Component) {
            Component component = (Component)partSem.getAbstractType();
            Collection ce = ComponentExt.getAllRelatedComponentExchange((Component)component);
            for (ComponentExchange c : ce) {
                super.hasntView(c.getId());
            }
        }
    }

    public BlockArchitectureExt.Type getDiagramType() {
        return this.type;
    }
}

