/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.epbs.ConfigurationItemKind;
import org.polarsys.capella.core.data.fa.FunctionKind;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XBreakdownDiagram
extends CommonDiagram {
    BlockArchitectureExt.Type type = null;

    public XBreakdownDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static XBreakdownDiagram createCBDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        if (type == BlockArchitectureExt.Type.OA) {
            name = "Operational Entity Breakdown";
        } else if (type == BlockArchitectureExt.Type.LA) {
            name = "Logical Component Breakdown";
        } else if (type == BlockArchitectureExt.Type.PA) {
            name = "Physical Component Breakdown";
        } else if (type == BlockArchitectureExt.Type.EPBS) {
            name = "Configuration Items Breakdown";
        }
        return (XBreakdownDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new XBreakdownDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static XBreakdownDiagram createFBDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        if (type == BlockArchitectureExt.Type.OA) {
            name = "Operational Activity Breakdown";
        } else if (type == BlockArchitectureExt.Type.SA) {
            name = "System Function Breakdown";
        } else if (type == BlockArchitectureExt.Type.LA) {
            name = "Logical Function Breakdown";
        } else if (type == BlockArchitectureExt.Type.PA) {
            name = "Physical Function Breakdown";
        }
        return (XBreakdownDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new XBreakdownDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static XBreakdownDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (XBreakdownDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new XBreakdownDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public void createFunction(String id, final int expectedNewElements, String kind, String containerId, final String realContainerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = "operational.activity";
        } else if (this.type == BlockArchitectureExt.Type.SA) {
            if (FunctionKind.FUNCTION.getLiteral().equals(kind)) {
                name = "system.function";
            } else if (FunctionKind.DUPLICATE.getLiteral().equals(kind)) {
                name = "duplicate";
            } else if (FunctionKind.GATHER.getLiteral().equals(kind)) {
                name = "gather";
            } else if (FunctionKind.ROUTE.getLiteral().equals(kind)) {
                name = "route";
            } else if (FunctionKind.SELECT.getLiteral().equals(kind)) {
                name = "select";
            } else if (FunctionKind.SPLIT.getLiteral().equals(kind)) {
                name = "split";
            }
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            if (FunctionKind.FUNCTION.getLiteral().equals(kind)) {
                name = "logical.function";
            } else if (FunctionKind.DUPLICATE.getLiteral().equals(kind)) {
                name = "duplicate";
            } else if (FunctionKind.GATHER.getLiteral().equals(kind)) {
                name = "gather";
            } else if (FunctionKind.ROUTE.getLiteral().equals(kind)) {
                name = "route";
            } else if (FunctionKind.SELECT.getLiteral().equals(kind)) {
                name = "select";
            } else if (FunctionKind.SPLIT.getLiteral().equals(kind)) {
                name = "split";
            }
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            if (FunctionKind.FUNCTION.getLiteral().equals(kind)) {
                name = "physical.function";
            } else if (FunctionKind.DUPLICATE.getLiteral().equals(kind)) {
                name = "duplicate";
            } else if (FunctionKind.GATHER.getLiteral().equals(kind)) {
                name = "gather";
            } else if (FunctionKind.ROUTE.getLiteral().equals(kind)) {
                name = "route";
            } else if (FunctionKind.SELECT.getLiteral().equals(kind)) {
                name = "select";
            } else if (FunctionKind.SPLIT.getLiteral().equals(kind)) {
                name = "split";
            }
        }
        new CreateNodeTool(this, name, containerId, id){

            @Override
            protected DSemanticDecorator getContainerView() {
                return this.getDiagramContext().getView(realContainerId != null && !"".equals(realContainerId) ? realContainerId : this.containerView);
            }

            @Override
            protected int expectedNewElements() {
                return expectedNewElements;
            }
        }.run();
    }

    public void createComponent(String id, int expectedNewElements, String containerId) {
        this.createComponent(id, expectedNewElements, "", containerId, containerId);
    }

    public void createComponent(String id, final int expectedNewElements, String kind, String containerId, final String realContainerId) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.OA) {
            name = OaPackage.Literals.ENTITY.getName().equals(kind) ? "operational.actor" : "operational.entity";
        } else if (this.type == BlockArchitectureExt.Type.LA) {
            name = "logical.component";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            if (PhysicalComponentNature.BEHAVIOR.getLiteral().equals(kind)) {
                name = "behavior.pc";
            } else if (PhysicalComponentNature.NODE.getLiteral().equals(kind)) {
                name = "node.pc";
            }
        } else if (this.type == BlockArchitectureExt.Type.EPBS) {
            if (ConfigurationItemKind.COTSCI.getLiteral().equals(kind)) {
                name = "cots";
            } else if (ConfigurationItemKind.CSCI.getLiteral().equals(kind)) {
                name = "cs";
            } else if (ConfigurationItemKind.HWCI.getLiteral().equals(kind)) {
                name = "hw";
            } else if (ConfigurationItemKind.INTERFACE_CI.getLiteral().equals(kind)) {
                name = "interface";
            } else if (ConfigurationItemKind.NDICI.getLiteral().equals(kind)) {
                name = "ndi";
            } else if (ConfigurationItemKind.PRIME_ITEM_CI.getLiteral().equals(kind)) {
                name = "prime.item";
            } else if (ConfigurationItemKind.SYSTEM_CI.getLiteral().equals(kind)) {
                name = "system";
            }
        }
        new CreateNodeTool(this, name, containerId, id){

            @Override
            protected DSemanticDecorator getContainerView() {
                return this.getDiagramContext().getView(realContainerId != null && !"".equals(realContainerId) ? realContainerId : this.containerView);
            }

            @Override
            protected int expectedNewElements() {
                return expectedNewElements;
            }
        }.run();
    }

    public void createActor(String id, String containerId, final boolean isHuman) {
        String name = null;
        if (this.type == BlockArchitectureExt.Type.LA) {
            name = "actor";
        } else if (this.type == BlockArchitectureExt.Type.PA) {
            name = "actor";
        }
        CreateNodeTool tool = new CreateNodeTool((DiagramContext)this, name, containerId, id);
        EObject result = ((DNode)tool.run()).getTarget();
        if (this.type == BlockArchitectureExt.Type.LA && result instanceof LogicalComponent || this.type == BlockArchitectureExt.Type.PA && result instanceof PhysicalComponent) {
            final Component actor = (Component)result;
            Assert.assertTrue((String)"the component created is not actor", (boolean)actor.isActor());
            TransactionHelper.getExecutionManager((EObject)actor).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    actor.setHuman(isHuman);
                }
            });
        } else {
            Assert.fail((String)" The result is not the expected one ");
        }
    }

    public void createCContainedIn(String sourceId, String targetId) {
        this.createCContainedIn(sourceId, targetId, null);
    }

    public void createCContainedIn(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Operational Entity Breakdown")) {
            name = "contained.in";
        } else if (this.isA("Logical Component Breakdown")) {
            name = "contained.in";
        } else if (this.isA("Physical Component Breakdown")) {
            name = "contained.in";
        } else if (this.isA("Configuration Items Breakdown")) {
            name = "contained.in";
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createFContainedIn(String sourceId, String targetId) {
        this.createFContainedIn(sourceId, targetId, null);
    }

    public void createFContainedIn(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Operational Activity Breakdown")) {
            name = "contained.in";
        } else if (this.isA("System Function Breakdown")) {
            name = "contained.in";
        } else if (this.isA("Logical Function Breakdown")) {
            name = "contained.in";
        } else if (this.isA("Physical Function Breakdown")) {
            name = "contained.in";
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }

    public void createPart(String sourceId, String targetId) {
        this.createPart(sourceId, targetId, this.getDiagramId());
    }

    public void createPart(String sourceId, String targetId, String id) {
        String name = null;
        if (this.isA("Logical Component Breakdown")) {
            name = "create.part";
        } else if (this.isA("Physical Component Breakdown")) {
            name = "create.part";
        }
        new CreateDEdgeTool(this, name, sourceId, targetId, id).run();
    }
}

