/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.AbstractDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.Messages;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.ToolWrapperFactory;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ToolHelper;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public abstract class AbstractToolStep<A>
extends AbstractDiagramStep<A> {
    protected String toolName;
    protected String toolLabel;
    protected AbstractToolWrapper _toolWrapper;

    public AbstractToolStep(DiagramContext diagramContext, String toolName) {
        super(diagramContext);
        this.toolName = toolName;
    }

    @Deprecated
    public AbstractToolStep(DiagramContext context, String toolName_p, String toolLabel_p) {
        super(context);
        this.toolName = toolName_p;
        this.toolLabel = toolLabel_p;
    }

    protected abstract void initToolArguments();

    private void initializeToolAndCheckArguments() {
        Session currentSession = this.getExecutionContext().getSession();
        DDiagram currentDiagram = this.getDiagramContext().getDiagram();
        ToolHelper toolHelper = new ToolHelper(currentSession, currentDiagram);
        AbstractToolDescription tool = null;
        if (this.toolLabel != null) {
            tool = toolHelper.getToolByLabel(this.toolName, this.toolLabel);
        }
        if (tool == null) {
            tool = toolHelper.getTool(this.toolName);
        }
        if (tool == null) {
            tool = toolHelper.getToolByLabel(this.toolName);
        }
        if (tool == null) {
            tool = toolHelper.getToolByLabel(this.toolLabel);
        }
        String diagramIdentifier = currentDiagram.getDescription().getName();
        Assert.assertNotNull((String)NLS.bind((String)Messages.toolDoesNotExist, (Object)this.toolName, (Object)diagramIdentifier), (Object)tool);
        this._toolWrapper = ToolWrapperFactory.INSTANCE.createToolCommandWrapper(tool);
        Assert.assertNotNull((String)NLS.bind((String)Messages.toolWrapperNotAvailable, (Object)this.toolName), (Object)this._toolWrapper);
        this.initToolArguments();
        IStatus isArgumentOk = this._toolWrapper.checkArguments();
        Assert.assertTrue((String)NLS.bind((String)Messages.toolWrapperArgumentErr, (Object)isArgumentOk.toString()), (boolean)isArgumentOk.isOK());
    }

    protected void preRunTest() {
        this.initializeToolAndCheckArguments();
        boolean isContextOk = this._toolWrapper.isContextOk();
        Assert.assertTrue((String)NLS.bind((String)Messages.toolWrapperArgumentValueErr, (Object)this.toolName), (boolean)isContextOk);
    }

    protected void runTest() {
        TestHelper.getExecutionManager((Session)this.getExecutionContext().getSession()).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                Command cmd = AbstractToolStep.this._toolWrapper.createCommand();
                Assert.assertTrue((String)NLS.bind((String)Messages.toolPreconditionFailed, (Object)AbstractToolStep.this.toolName), (!UnexecutableCommand.INSTANCE.equals(cmd) ? 1 : 0) != 0);
                cmd.execute();
            }
        });
    }

    public void contextOk() {
        this.initializeToolAndCheckArguments();
        boolean isContextOk = this._toolWrapper.isContextOk();
        Assert.assertTrue((String)NLS.bind((String)Messages.toolWrapperArgumentValueFailedErr, (Object)this.toolName), (boolean)isContextOk);
    }

    public void shouldFail() {
        this.initializeToolAndCheckArguments();
        boolean isContextOk = this._toolWrapper.isContextOk();
        Assert.assertFalse((String)NLS.bind((String)Messages.toolWrapperArgumentValueFailedErr, (Object)this.toolName), (boolean)isContextOk);
    }

    public void cannotRun() {
        try {
            this.preRunTest();
            TestHelper.getExecutionManager((Session)this.getExecutionContext().getSession()).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    Command cmd = AbstractToolStep.this._toolWrapper.createCommand();
                    Assert.assertTrue((boolean)UnexecutableCommand.INSTANCE.equals(cmd));
                }
            });
        }
        finally {
            this.dispose();
        }
    }
}

