/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;

public class DragAndDropTool
extends AbstractToolStep<DDiagramElement> {
    protected String containerView;
    protected String elementView;
    protected Collection<DDiagramElement> _elements;
    protected Collection<DDiagramElement> _newElements;

    public DragAndDropTool(DiagramContext context, String toolName, String containerView) {
        super(context, toolName);
        this.containerView = containerView;
    }

    public DragAndDropTool(DiagramContext context, String toolName, String elementView, String containerView) {
        this(context, toolName, containerView);
        this.elementView = elementView;
    }

    @Override
    protected void preRunTest() {
        super.preRunTest();
        DSemanticDecorator element = this.getDiagramContext().getView(this.containerView);
        this._elements = DiagramHelper.getOwnedElements(element);
    }

    protected void dispose() {
        super.dispose();
        this._elements = null;
        this._newElements = null;
    }

    protected void postRunTest() {
        super.postRunTest();
        DSemanticDecorator element = this.getDiagramContext().getView(this.containerView);
        this._newElements = DiagramHelper.getOwnedElements(element);
        this._newElements.removeAll(this._elements);
        this.validateNewElements(this._newElements);
    }

    protected void validateNewElements(Collection<DDiagramElement> newElements) {
        Assert.assertEquals((long)1L, (long)this._newElements.size());
    }

    public DDiagramElement getResult() {
        DDiagramElement view = this._newElements.iterator().next();
        if (this.elementView != null) {
            this.getExecutionContext().putSemanticElement(this.elementView, view.getTarget());
            this.getDiagramContext().putView(this.elementView, view);
        }
        return view;
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator droppedElement = this.getDiagramContext().getView(this.elementView);
        DSemanticDecorator element = this.getDiagramContext().getView(this.containerView);
        EObject droppedElementSemantic = this.getExecutionContext().getSemanticElement(this.elementView);
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, element);
        if (droppedElement != null) {
            this._toolWrapper.setArgumentValue(ArgumentType.DROPPEDELEMENT, droppedElement);
        } else if (droppedElementSemantic != null) {
            this._toolWrapper.setArgumentValue(ArgumentType.DROPPEDELEMENT, droppedElementSemantic);
        }
    }
}

