/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.factory;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.diagram.tools.api.command.DiagramCommandFactoryService;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractCommonToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.ContainerCreationDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.ContainerDropDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.DeleteCreationDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.EdgeCreationDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.NodeCreationDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.ReconnectEdgeDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.AbstractToolWrapperFactory;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class DiagramToolWrapperFactory
extends AbstractToolWrapperFactory {
    @Override
    public EPackage getTargetEPackage() {
        return ToolPackage.eINSTANCE;
    }

    @Override
    public ICommandFactory getDefaultCommandFactory() {
        TransactionalEditingDomain editingDomain = TestHelper.getEditingDomain();
        if (editingDomain == null) {
            ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
            editingDomain = manager.getEditingDomain();
        }
        return DiagramCommandFactoryService.getInstance().getNewProvider().getCommandFactory(editingDomain);
    }

    @Override
    public AbstractToolWrapper createToolCommandWrapper(AbstractToolDescription tool_p, ICommandFactory cmdFactory_p) {
        Assert.isNotNull((Object)tool_p);
        Assert.isTrue((boolean)(cmdFactory_p instanceof IDiagramCommandFactory));
        IDiagramCommandFactory commandFactory = (IDiagramCommandFactory)cmdFactory_p;
        AbstractCommonToolWrapper result = null;
        EClass eclass = tool_p.eClass();
        if (ToolPackage.Literals.CONTAINER_CREATION_DESCRIPTION.equals(eclass)) {
            result = new ContainerCreationDescriptionWrapper(tool_p, commandFactory);
        } else if (ToolPackage.Literals.NODE_CREATION_DESCRIPTION.equals(eclass)) {
            result = new NodeCreationDescriptionWrapper(tool_p, commandFactory);
        } else if (ToolPackage.Literals.EDGE_CREATION_DESCRIPTION.equals(eclass)) {
            result = new EdgeCreationDescriptionWrapper(tool_p, commandFactory);
        } else if (ToolPackage.Literals.DELETE_ELEMENT_DESCRIPTION.equals(eclass)) {
            result = new DeleteCreationDescriptionWrapper(tool_p, commandFactory);
        } else if (ToolPackage.Literals.RECONNECT_EDGE_DESCRIPTION.equals(eclass)) {
            result = new ReconnectEdgeDescriptionWrapper(tool_p, commandFactory);
        } else if (ToolPackage.Literals.CONTAINER_DROP_DESCRIPTION.equals(eclass)) {
            result = new ContainerDropDescriptionWrapper(tool_p, commandFactory);
        }
        return result;
    }
}

