/*******************************************************************************
 * Copyright (c) 2017 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.test.diagram.layout.ju.layout.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.polarsys.capella.test.diagram.layout.ju.layout.util.LayoutAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class LayoutItemProviderAdapterFactory extends LayoutAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
  /**
   * This keeps track of the root adapter factory that delegates to this adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected ComposedAdapterFactory parentAdapterFactory;

  /**
   * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

  /**
   * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected Collection<Object> supportedTypes = new ArrayList<Object>();

  /**
   * This constructs an instance.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public LayoutItemProviderAdapterFactory() {
    supportedTypes.add(IEditingDomainItemProvider.class);
    supportedTypes.add(IStructuredItemContentProvider.class);
    supportedTypes.add(ITreeItemContentProvider.class);
    supportedTypes.add(IItemLabelProvider.class);
    supportedTypes.add(IItemPropertySource.class);
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.test.diagram.layout.ju.layout.DiagramLayout} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected DiagramLayoutItemProvider diagramLayoutItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.test.diagram.layout.ju.layout.DiagramLayout}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createDiagramLayoutAdapter() {
    if (diagramLayoutItemProvider == null) {
      diagramLayoutItemProvider = new DiagramLayoutItemProvider(this);
    }

    return diagramLayoutItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.test.diagram.layout.ju.layout.EdgeLayout} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EdgeLayoutItemProvider edgeLayoutItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.test.diagram.layout.ju.layout.EdgeLayout}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createEdgeLayoutAdapter() {
    if (edgeLayoutItemProvider == null) {
      edgeLayoutItemProvider = new EdgeLayoutItemProvider(this);
    }

    return edgeLayoutItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.test.diagram.layout.ju.layout.NodeLayout} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected NodeLayoutItemProvider nodeLayoutItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.test.diagram.layout.ju.layout.NodeLayout}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createNodeLayoutAdapter() {
    if (nodeLayoutItemProvider == null) {
      nodeLayoutItemProvider = new NodeLayoutItemProvider(this);
    }

    return nodeLayoutItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.test.diagram.layout.ju.layout.NoteLayout} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected NoteLayoutItemProvider noteLayoutItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.test.diagram.layout.ju.layout.NoteLayout}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createNoteLayoutAdapter() {
    if (noteLayoutItemProvider == null) {
      noteLayoutItemProvider = new NoteLayoutItemProvider(this);
    }

    return noteLayoutItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.test.diagram.layout.ju.layout.SessionLayout} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected SessionLayoutItemProvider sessionLayoutItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.test.diagram.layout.ju.layout.SessionLayout}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createSessionLayoutAdapter() {
    if (sessionLayoutItemProvider == null) {
      sessionLayoutItemProvider = new SessionLayoutItemProvider(this);
    }

    return sessionLayoutItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.test.diagram.layout.ju.layout.Bounds} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected BoundsItemProvider boundsItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.test.diagram.layout.ju.layout.Bounds}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createBoundsAdapter() {
    if (boundsItemProvider == null) {
      boundsItemProvider = new BoundsItemProvider(this);
    }

    return boundsItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.test.diagram.layout.ju.layout.Location} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected LocationItemProvider locationItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.test.diagram.layout.ju.layout.Location}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createLocationAdapter() {
    if (locationItemProvider == null) {
      locationItemProvider = new LocationItemProvider(this);
    }

    return locationItemProvider;
  }

  /**
   * This keeps track of the one adapter used for all {@link org.polarsys.capella.test.diagram.layout.ju.layout.Size} instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected SizeItemProvider sizeItemProvider;

  /**
   * This creates an adapter for a {@link org.polarsys.capella.test.diagram.layout.ju.layout.Size}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter createSizeAdapter() {
    if (sizeItemProvider == null) {
      sizeItemProvider = new SizeItemProvider(this);
    }

    return sizeItemProvider;
  }

  /**
   * This returns the root adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public ComposeableAdapterFactory getRootAdapterFactory() {
    return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
  }

  /**
   * This sets the composed adapter factory that contains this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
    this.parentAdapterFactory = parentAdapterFactory;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object type) {
    return supportedTypes.contains(type) || super.isFactoryForType(type);
  }

  /**
   * This implementation substitutes the factory itself as the key for the adapter.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Adapter adapt(Notifier notifier, Object type) {
    return super.adapt(notifier, this);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object adapt(Object object, Object type) {
    if (isFactoryForType(type)) {
      Object adapter = super.adapt(object, type);
      if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
        return adapter;
      }
    }

    return null;
  }

  /**
   * This adds a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void addListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.addListener(notifyChangedListener);
  }

  /**
   * This removes a listener.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void removeListener(INotifyChangedListener notifyChangedListener) {
    changeNotifier.removeListener(notifyChangedListener);
  }

  /**
   * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void fireNotifyChanged(Notification notification) {
    changeNotifier.fireNotifyChanged(notification);

    if (parentAdapterFactory != null) {
      parentAdapterFactory.fireNotifyChanged(notification);
    }
  }

  /**
   * This disposes all of the item providers created by this factory. 
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void dispose() {
    if (diagramLayoutItemProvider != null) diagramLayoutItemProvider.dispose();
    if (edgeLayoutItemProvider != null) edgeLayoutItemProvider.dispose();
    if (nodeLayoutItemProvider != null) nodeLayoutItemProvider.dispose();
    if (noteLayoutItemProvider != null) noteLayoutItemProvider.dispose();
    if (sessionLayoutItemProvider != null) sessionLayoutItemProvider.dispose();
    if (boundsItemProvider != null) boundsItemProvider.dispose();
    if (locationItemProvider != null) locationItemProvider.dispose();
    if (sizeItemProvider != null) sizeItemProvider.dispose();
  }

}
