/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class Bug1006TestCase
extends BasicTestCase {
    private String diagramName = "[PAB] Physical System";
    private String projectTestName = "bug1006";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    public void test() throws Exception {
        Session session = this.getSession(this.projectTestName);
        Bug1006TestCase.assertNotNull((Object)session);
        IFile airdFile = this.getAirdFileForLoadedModel(this.projectTestName);
        Assert.assertNotNull((Object)airdFile);
        GuiActions.openSession((IFile)airdFile, (boolean)true);
        DDiagram diagram = (DDiagram)DiagramHelper.getDRepresentation((Session)session, (String)this.diagramName);
        Bug1006TestCase.assertNotNull((String)MessageFormat.format("{0} diagram is not contained in the session associated to {1} file", this.diagramName, airdFile), (Object)diagram);
        SessionContext sessionContext = new SessionContext(session);
        final DiagramContext diagramContext = new DiagramContext(sessionContext, diagram);
        long time = System.currentTimeMillis();
        Thread t = new Thread(){

            @Override
            public void run() {
                Bug1006TestCase.this.openDiagram(diagramContext);
            }
        };
        try {
            t.start();
            t.join(12000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (System.currentTimeMillis() - time < 10000L) {
            Bug1006TestCase.assertTrue((String)"Diagram should open in less than 10 seconds", (boolean)false);
        }
    }

    private void openDiagram(DiagramContext diagramContext) {
        try {
            diagramContext.open();
        }
        catch (Exception ex) {
            Bug1006TestCase.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }
}

