/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.junit.Assert;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class Bug1917TestCase
extends BasicTestCase {
    private String projectTestName = "bug1917";
    private String diagramName1 = "[PAB] Physical System 1";
    private String diagramName2 = "[PAB] Physical System 2";
    private String diagramName3 = "[PAB] Physical System 3";
    private String diagramName4 = "[PAB] Physical System 4";
    private String diagramName5 = "[PAB] Physical System 5";
    private String diagramName6 = "[PAB] Physical System 6";
    private String diagramName7 = "[PAB] Physical System 7";
    private String diagramName8 = "[PAB] Physical System 8";
    private String[] diag1InternalLinkIds = new String[]{"c0e58764-42d0-4b53-90b2-0e356d715f8a", "be17092c-0e29-4673-a0a6-f17bddf1ebe2"};
    private String[] diag2InternalLinkIds = new String[]{"87d246b5-c248-4d9f-bb47-b1aa3819b60f", "f32d3692-70ca-4760-847a-380c9d17cbcd"};
    private String[] diag3InternalLinkIds = new String[]{"b964db82-bc73-4580-a700-53c0c3134cb4", "da05514b-a0d0-4775-866a-f170ccc2b52c"};
    private String[] diag4InternalLink1Ids = new String[]{"f383c31a-f65b-4eb8-ba3f-a0d8f9d63025", "99c459dc-d9af-468f-90ac-351dd8843e1d"};
    private String[] diag4InternalLink2Ids = new String[]{"16016add-0b5e-46ef-80c5-232981d3fd98", "7b149ae3-2c4c-453c-9ba9-570c1c5a1798"};
    private String[] diag5InternalLink1Ids = new String[]{"99db633e-029b-4aef-9bef-b2f88e8aec3a", "906f126b-2009-4936-abcf-b3728d78cb00"};
    private String[] diag5InternalLink2Ids = new String[]{"e3c448ae-e128-4445-b71a-c9b4426c2769", "73400651-9742-4e96-b8c1-7cf9bdfb7cf3"};
    private String[] diag6InternalLinkIds = new String[]{"9d807763-412b-4d93-87e5-b0eaa3c6ab14", "bb76ad61-9d4f-497c-b86e-3e7e2109bfd5"};
    private String[] diag7InternalLink1Ids = new String[]{"107698e3-5665-464d-b136-69699d21d38a", "12bf742b-358d-40fd-8691-548b65698750"};
    private String[] diag7InternalLink2Ids = new String[]{"7f04edf3-6111-49a4-9de2-6e1e12eee8d9", "dfae386d-1637-4099-9612-0ae2680ff492"};
    private String[] diag7InternalLink3Ids = new String[]{"107698e3-5665-464d-b136-69699d21d38a", "3c73230b-d6f0-4a34-b3c5-7acf7407c488"};
    private String[] diag7InternalLink4Ids = new String[]{"6fa0b1a7-b072-4f44-ab0d-52f516f1449a", "2a14bec3-a1fe-41f3-99ea-848747830209"};
    private String[] diag8InternalLink1Ids = new String[]{"6c5ba9e1-8593-45a0-bcf3-76c2b7bf3d06", "2eb644da-e866-4e1c-ba53-f043a6d70b51"};
    private String[] diag8InternalLink2Ids = new String[]{"b5d33fd7-8c2b-4808-96f6-2e106c157503", "f626e973-b36f-4a76-86e3-acedbe9a2a18"};
    private String[] diag8InternalLink3Ids = new String[]{"f626e973-b36f-4a76-86e3-acedbe9a2a18", "3c6eccae-502a-48f1-98d9-5dd54cafb287"};
    private String[] diag8InternalLink4Ids = new String[]{"bfff6a9c-53ef-43f1-9333-3100a6bad3d8", "0081811c-c036-491b-b591-1528567efa63"};

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    public void test() throws Exception {
        Session session = this.getSession(this.projectTestName);
        Bug1917TestCase.assertNotNull((Object)session);
        IFile airdFile = this.getAirdFileForLoadedModel(this.projectTestName);
        Assert.assertNotNull((Object)airdFile);
        GuiActions.openSession((IFile)airdFile, (boolean)true);
        this.testDiagram(session, this.diagramName1, 3);
        this.testInternalLink(session, this.diagramName1, this.diag1InternalLinkIds);
        this.testDiagram(session, this.diagramName2, 3);
        this.testInternalLink(session, this.diagramName2, this.diag2InternalLinkIds);
        this.testDiagram(session, this.diagramName3, 3);
        this.testInternalLink(session, this.diagramName3, this.diag3InternalLinkIds);
        this.testDiagram(session, this.diagramName4, 5);
        this.testInternalLink(session, this.diagramName4, this.diag4InternalLink1Ids);
        this.testInternalLink(session, this.diagramName4, this.diag4InternalLink2Ids);
        this.testDiagram(session, this.diagramName5, 5);
        this.testInternalLink(session, this.diagramName5, this.diag5InternalLink1Ids);
        this.testInternalLink(session, this.diagramName5, this.diag5InternalLink2Ids);
        this.testDiagram(session, this.diagramName6, 3);
        this.testInternalLink(session, this.diagramName6, this.diag6InternalLinkIds);
        this.testDiagram(session, this.diagramName7, 10);
        this.testInternalLink(session, this.diagramName7, this.diag7InternalLink1Ids);
        this.testInternalLink(session, this.diagramName7, this.diag7InternalLink2Ids);
        this.testInternalLink(session, this.diagramName7, this.diag7InternalLink3Ids);
        this.testInternalLink(session, this.diagramName7, this.diag7InternalLink4Ids);
        this.testDiagram(session, this.diagramName8, 9);
        this.testInternalLink(session, this.diagramName8, this.diag8InternalLink1Ids);
        this.testInternalLink(session, this.diagramName8, this.diag8InternalLink2Ids);
        this.testInternalLink(session, this.diagramName8, this.diag8InternalLink3Ids);
        this.testInternalLink(session, this.diagramName8, this.diag8InternalLink4Ids);
    }

    private void testDiagram(Session session, String diagramName, int expectedNbOfEdges) {
        DDiagram diagram = (DDiagram)DiagramHelper.getDRepresentation((Session)session, (String)diagramName);
        SessionContext sessionContext = new SessionContext(session);
        DiagramContext diagramContext = new DiagramContext(sessionContext, diagram);
        this.openDiagram(diagramContext);
        Bug1917TestCase.assertTrue((diagram.getEdges().size() == expectedNbOfEdges ? 1 : 0) != 0);
    }

    private void testInternalLink(Session session, String diagramName, String[] ids) {
        DDiagram diagram = (DDiagram)DiagramHelper.getDRepresentation((Session)session, (String)diagramName);
        SessionContext sessionContext = new SessionContext(session);
        DiagramContext diagramContext = new DiagramContext(sessionContext, diagram);
        EdgeTarget sourceNode = (EdgeTarget)diagramContext.getView(ids[0]);
        Bug1917TestCase.assertNotNull((Object)sourceNode);
        EdgeTarget targetNode = (EdgeTarget)diagramContext.getView(ids[1]);
        Bug1917TestCase.assertNotNull((Object)targetNode);
        DEdge internalLink = null;
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges(sourceNode)) {
            if (!(anEdge.getTarget() instanceof PhysicalPath) || anEdge.getSourceNode() == null || anEdge.getTargetNode() == null) continue;
            if (anEdge.getSourceNode().equals(sourceNode) && anEdge.getTargetNode().equals(targetNode)) {
                internalLink = anEdge;
                break;
            }
            if (!anEdge.getSourceNode().equals(targetNode) || !anEdge.getTargetNode().equals(sourceNode)) continue;
            internalLink = anEdge;
            break;
        }
        for (DEdge anEdge : DiagramServices.getDiagramServices().getIncomingEdges(sourceNode)) {
            if (!(anEdge.getTarget() instanceof PhysicalPath) || anEdge.getSourceNode() == null || anEdge.getTargetNode() == null) continue;
            if (anEdge.getSourceNode().equals(sourceNode) && anEdge.getTargetNode().equals(targetNode)) {
                internalLink = anEdge;
                break;
            }
            if (!anEdge.getSourceNode().equals(targetNode) || !anEdge.getTargetNode().equals(sourceNode)) continue;
            internalLink = anEdge;
            break;
        }
        Bug1917TestCase.assertNotNull(internalLink);
    }

    private void openDiagram(DiagramContext diagramContext) {
        try {
            diagramContext.open();
        }
        catch (Exception ex) {
            Bug1917TestCase.assertTrue((String)ex.getMessage(), (boolean)false);
        }
    }
}

