/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.BooleanPropertyValue;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.PropertyValueGroup;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.tools.ju.common.DragAndDropPvTool;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class CommonToolsTest
extends AbstractDiagramTestCase {
    protected SessionContext sc;
    protected Session s;
    protected PropertyValueGroup pvg;
    protected BooleanPropertyValue pv;
    protected Collection<DiagramElementMapping> testedMappings = new HashSet<DiagramElementMapping>();
    protected Collection<DiagramDescription> testedDiagrams = new HashSet<DiagramDescription>();

    protected String getRequiredTestModel() {
        return "In-Flight Entertainment System";
    }

    public void test() throws Exception {
        this.s = this.getSession(this.getRequiredTestModel());
        this.sc = new SessionContext(this.s);
        TransactionalEditingDomain ed = this.s.getTransactionalEditingDomain();
        this.s.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(ed){

            protected void doExecute() {
                Project proj = (Project)TestHelper.getSemanticResource((Session)CommonToolsTest.this.s).getContents().get(0);
                CommonToolsTest.this.pv = CapellacoreFactory.eINSTANCE.createBooleanPropertyValue();
                CommonToolsTest.this.pvg = CapellacoreFactory.eINSTANCE.createPropertyValueGroup();
                CommonToolsTest.this.pvg.getOwnedPropertyValues().add((Object)CapellacoreFactory.eINSTANCE.createBooleanPropertyValue());
                proj.getOwnedPropertyValues().add((Object)CommonToolsTest.this.pv);
                proj.getOwnedPropertyValueGroups().add((Object)CommonToolsTest.this.pvg);
            }
        });
        CommonToolsTest.assertNotNull((Object)this.pv);
        CommonToolsTest.assertNotNull((Object)this.pvg);
        for (DRepresentation rep : DialectManager.INSTANCE.getAllRepresentations(this.s)) {
            if (!(rep instanceof DDiagram)) continue;
            System.err.println(EObjectExt.getText((EObject)rep));
            this.testCommonTools((DDiagram)rep);
        }
    }

    private void testCommonTools(final DDiagram rep) {
        this.s.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.s.getTransactionalEditingDomain()){

            protected void doExecute() {
                rep.getActivatedFilters().clear();
            }
        });
        CommonDiagram cd = new CommonDiagram(this.sc, rep);
        DiagramContext dc = cd.open();
        Session session = dc.getSessionContext().getSession();
        for (DDiagramElement de : new ArrayList(dc.getDiagram().getOwnedDiagramElements())) {
            if (!this.testedMappings.add(de.getDiagramElementMapping()) || !(de.getTarget() instanceof CapellaElement)) continue;
            final CapellaElement ce = (CapellaElement)de.getTarget();
            session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(session.getTransactionalEditingDomain()){

                protected void doExecute() {
                    ce.getAppliedPropertyValueGroups().add((Object)CommonToolsTest.this.pvg);
                    ce.getAppliedPropertyValues().add((Object)CommonToolsTest.this.pv);
                }
            });
            String containerId = ce.getId();
            cd.insertPV(this.pv.getId(), containerId);
            cd.insertPVG(this.pvg.getId(), containerId);
            cd.refreshDiagram();
            cd.removePVG(this.pvg.getId(), containerId);
            cd.removePV(this.pv.getId(), containerId);
        }
        if (this.testedDiagrams.add(rep.getDescription())) {
            new DragAndDropPvTool(dc, (AbstractPropertyValue)this.pv, dc.getDiagramId()).run();
            new DragAndDropPvTool(dc, this.pvg, dc.getDiagramId()).run();
            boolean pvFilterPresent = false;
            EList filters = rep.getDescription().getFilters();
            for (FilterDescription fd : filters) {
                if (!"hide.property.values.filter".equals(fd.getName())) continue;
                pvFilterPresent = true;
                break;
            }
            CommonToolsTest.assertTrue((boolean)pvFilterPresent);
        }
    }
}

