/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.context.SessionContext;

public class SelectToolsTest
extends AbstractDiagramTestCase {
    protected SessionContext sc;
    protected Session s;
    protected Collection<DiagramDescription> testedDiagrams = new HashSet<DiagramDescription>();

    protected String getRequiredTestModel() {
        return "In-Flight Entertainment System";
    }

    public void test() throws Exception {
        this.s = this.getSession(this.getRequiredTestModel());
        this.sc = new SessionContext(this.s);
        HashSet<DiagramDescription> descriptions = new HashSet<DiagramDescription>();
        for (DRepresentation rep : DialectManager.INSTANCE.getAllRepresentations(this.s)) {
            DDiagram diagram;
            if (!(rep instanceof DDiagram) || descriptions.contains((diagram = (DDiagram)rep).getDescription())) continue;
            descriptions.add(diagram.getDescription());
            this.testCommonTools(diagram);
        }
    }

    protected void testCommonTools(final DDiagram rep) {
        this.s.getTransactionalEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.s.getTransactionalEditingDomain()){

            protected void doExecute() {
                rep.getActivatedFilters().clear();
            }
        });
        CommonDiagram cd = new CommonDiagram(this.sc, rep);
        DiagramContext dc = cd.open();
        HashSet<DiagramElementMapping> mapping = new HashSet<DiagramElementMapping>();
        for (DDiagramElement de : new ArrayList(dc.getDiagram().getOwnedDiagramElements())) {
            if (!DiagramHelper.isDiagramElementSelectable((DDiagramElement)de) || mapping.contains(de.getDiagramElementMapping())) continue;
            mapping.add(de.getDiagramElementMapping());
            if (de instanceof DNodeContainer) {
                cd.selectOwnedElements(de.getUid());
            }
            if (de instanceof AbstractDNode) {
                cd.selectRelatedEdges(de.getUid());
            }
            if (de instanceof AbstractDNode) {
                cd.selectOwnedPorts(de.getUid());
            }
            cd.selectSameType(de.getUid());
            cd.selectSameMapping(de.getUid());
        }
        dc.close();
    }
}

