/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.idb;

import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.test.diagram.common.ju.context.IDBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class DragAndDropTest
extends EmptyProject {
    IDBDiagram idbSetup;
    String actor1;
    String component1;
    String component2;
    String component2_1;
    Component objComp2;
    Component objComp2_1;
    String interface1;
    String interface2;
    String interface3;
    Interface objIntf1;
    Interface objIntf2;
    Interface objIntf3;
    String ei1;
    String ei2;
    String constraint;
    String port;

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnDiagramIDB(context, "Interfaces Diagram Blank");
        this.testOnDiagramCII(context, "Contextual Component Internal Interfaces");
        this.testOnDiagramCDI(context, "Contextual Component Detailed Interfaces");
        this.testOnDiagramCEI(context, "Contextual Component External Interfaces");
    }

    private void testOnDiagramIDB(SessionContext context, String diagramKind) {
        this.init(context);
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        String diagramId = idb.getDiagramId();
        idb.dragAndDropComponentFromExplorer(this.actor1, diagramId);
        idb.dragAndDropComponentFromExplorer(this.component1, diagramId);
        idb.dragAndDropComponentFromExplorer(this.component2_1, diagramId);
        idb.dragAndDropComponentFromExplorer(this.component2, diagramId);
        DragAndDropTest.assertTrue((boolean)this.objComp2_1.eContainer().equals(this.objComp2));
        idb.dragAndDropInterfaceFromExplorer(this.interface1, diagramId);
        idb.dragAndDropInterfaceFromExplorer(this.interface2, this.component2);
        idb.dragAndDropInterfaceFromExplorer(this.interface3, this.component2_1);
        DragAndDropTest.assertTrue((boolean)this.objIntf2.eContainer().eContainer().equals(this.objComp2));
        DragAndDropTest.assertTrue((boolean)this.objIntf3.eContainer().eContainer().equals(this.objComp2_1));
        idb.dragAndDropInterfaceFromDiagram(this.interface2, this.component2_1);
        idb.dragAndDropInterfaceFromDiagram(this.interface1, this.component1);
        idb.dragAndDropInterfaceFromDiagram(this.interface1, diagramId);
        idb.dragAndDropInterfaceFromDiagram(this.interface2, this.component2);
        String component3 = idb.createComponent();
        String component4 = idb.createComponent();
        idb.dragAndDropComponentFromDiagram(component3, component4);
        idb.dragAndDropExchangeItemAllocationFromExplorer(this.ei1, this.interface1);
        String ei = idb.createExchangeItem(ExchangeMechanism.EVENT);
        String interf = idb.createInterface();
        idb.dragAndDropExchangeItemAllocationFromDiagram(ei, interf);
        String actor2 = idb.createActor();
        String port2 = idb.createStandardPort(this.actor1, GenericModel.COMPONENT_PORT_2);
        idb.dragAndDropComponentPortFromDiagram(port2, actor2);
        idb.dragAndDropConstraintFromExplorer(this.constraint, diagramId);
    }

    private void testOnDiagramCII(SessionContext context, String diagramKind) {
        this.init(context);
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        String diagramId = idb.getDiagramId();
        String containerId = "32f06455-48c7-4d68-aea5-cf397ab4aff2";
        String component1 = idb.createComponent(containerId, GenericModel.COMPONENT_1);
        String component2 = idb.createComponent(containerId, GenericModel.COMPONENT_2);
        String component2_1 = idb.createComponent(containerId, GenericModel.COMPONENT_2_1);
        idb.dragAndDropInterfaceFromExplorer(this.interface1, diagramId);
        idb.dragAndDropInterfaceFromExplorer(this.interface2, diagramId);
        idb.dragAndDropInterfaceFromExplorer(this.interface3, diagramId);
        idb.dragAndDropInterfaceFromDiagram(this.interface2, component2_1);
        idb.dragAndDropInterfaceFromDiagram(this.interface1, component1);
        idb.dragAndDropInterfaceFromDiagram(this.interface1, diagramId);
        idb.dragAndDropInterfaceFromDiagram(this.interface2, component2);
        idb.dragAndDropComponentFromDiagram(component2_1, component1);
        idb.dragAndDropComponentFromDiagram(component2_1, component2);
        idb.dragAndDropExchangeItemAllocationFromExplorer(this.ei1, diagramId);
        String ei = idb.createExchangeItemNode(ExchangeMechanism.EVENT);
        idb.dragAndDropExchangeItemAllocationFromDiagram(ei, containerId);
        String port2 = idb.createStandardPort(component1, GenericModel.COMPONENT_PORT_2);
        idb.dragAndDropComponentPortFromDiagram(port2, component2);
        idb.dragAndDropConstraintFromExplorer(this.constraint, diagramId);
    }

    private void testOnDiagramCDI(SessionContext context, String diagramKind) {
        this.init(context);
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        String diagramId = idb.getDiagramId();
        idb.dragAndDropInterfaceFromExplorer(this.interface1, diagramId);
        idb.dragAndDropInterfaceFromExplorer(this.interface2, diagramId);
        idb.dragAndDropInterfaceFromExplorer(this.interface3, diagramId);
        idb.dragAndDropExchangeItemAllocationFromExplorer(this.ei1, diagramId);
        String ei = idb.createExchangeItem(ExchangeMechanism.EVENT);
        String interf = idb.createInterface();
        idb.dragAndDropExchangeItemAllocationFromDiagram(ei, interf);
        idb.dragAndDropConstraintFromExplorer(this.constraint, diagramId);
    }

    private void testOnDiagramCEI(SessionContext context, String diagramKind) {
        this.init(context);
        IDBDiagram idb = IDBDiagram.createDiagram((SessionContext)context, (String)diagramKind, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        String diagramId = idb.getDiagramId();
        idb.dragAndDropComponentFromExplorer(this.component1, diagramId);
        idb.dragAndDropInterfaceFromExplorer(this.interface1, diagramId);
        idb.dragAndDropInterfaceFromExplorer(this.interface2, diagramId);
        idb.dragAndDropInterfaceFromExplorer(this.interface3, diagramId);
        idb.dragAndDropExchangeItemAllocationFromExplorer(this.ei1, diagramId);
        idb.dragAndDropConstraintFromExplorer(this.constraint, diagramId);
    }

    private void init(SessionContext context) {
        this.idbSetup = IDBDiagram.createDiagram((SessionContext)context, (String)"32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.actor1 = this.idbSetup.createActor();
        this.component1 = this.idbSetup.createComponent();
        this.component2 = this.idbSetup.createComponent();
        this.component2_1 = this.idbSetup.createSubComponent(this.component2);
        this.objComp2 = (Component)this.idbSetup.getSessionContext().getSemanticElement(this.component2);
        this.objComp2_1 = (Component)this.idbSetup.getSessionContext().getSemanticElement(this.component2_1);
        this.interface1 = this.idbSetup.createInterface();
        this.interface2 = this.idbSetup.createInterfaceInContainer(this.component2);
        this.interface3 = this.idbSetup.createInterfaceInContainer(this.component2_1);
        this.objIntf1 = (Interface)this.idbSetup.getSessionContext().getSemanticElement(this.interface1);
        this.objIntf2 = (Interface)this.idbSetup.getSessionContext().getSemanticElement(this.interface2);
        this.objIntf3 = (Interface)this.idbSetup.getSessionContext().getSemanticElement(this.interface3);
        this.ei1 = this.idbSetup.createExchangeItem(ExchangeMechanism.EVENT);
        this.ei2 = this.idbSetup.createExchangeItem(ExchangeMechanism.FLOW);
        this.port = this.idbSetup.createStandardPort(this.actor1, GenericModel.COMPONENT_PORT_1);
        this.constraint = this.idbSetup.createConstraint(GenericModel.CONSTRAINT_1);
    }
}

