/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.mcb;

import junit.framework.Test;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.test.diagram.common.ju.context.CapabilityDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.MissionDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class InsertRemoveScenario
extends EmptyProject {
    String actor1;
    String actor2;
    String capability1;
    String capability2;
    String mission1;
    String mission2;

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.createOperationalAnalysis(context);
        this.testOn(context, this.capability1, "Contextual Operational Capability");
        this.testOn(context, "17272056-0c09-4f18-879c-3abd881be0d7", "Operational Capabilities Blank");
        this.createSystemAnalysis(context);
        this.testOn(context, "2e8f8d52-dc83-45a2-b64c-31e676486b4c", "Missions Capabilities Blank");
        this.testOn(context, this.capability1, "Contextual Capability");
        this.testOn(context, this.mission1, "Contextual Mission");
        this.testOn(context, "080eb8d2-1970-42dd-9540-cacaa1018452", "Missions Blank");
        this.createLogicalArchitecture(context);
        this.testOn(context, "d89e7f00-8f98-4a05-a9ee-930307efee73", "Capability Realization Blank");
        this.createPhysicalArchitecture(context);
        this.testOn(context, "b02dd33a-ffa1-47fa-96dc-fa0863aab9ee", "Capability Realization Blank");
    }

    protected void testOn(SessionContext context, String sourceId, String diagramName) {
        CapabilityDiagram diagramContext = CapabilityDiagram.createDiagram((SessionContext)context, (String)sourceId, (String)diagramName);
        diagramContext.insertActor(this.actor1);
        diagramContext.removeActor(this.actor1);
        diagramContext.insertCapability(new String[]{this.capability2});
        diagramContext.removeCapability(new String[]{this.capability2});
        if (diagramContext instanceof MissionDiagram && ((MissionDiagram)diagramContext).canInsertMission()) {
            ((MissionDiagram)diagramContext).insertMission(this.mission2);
            ((MissionDiagram)diagramContext).removeMission(this.mission2);
        }
    }

    protected void createOperationalAnalysis(SessionContext context) {
        CapabilityDiagram diagram = CapabilityDiagram.createDiagram((SessionContext)context, (String)"17272056-0c09-4f18-879c-3abd881be0d7", (String)"Operational Capabilities Blank");
        this.capability1 = diagram.createCapability();
        this.capability2 = diagram.createCapability();
        this.actor1 = diagram.createActor();
    }

    protected void createSystemAnalysis(SessionContext context) {
        MissionDiagram diagram = MissionDiagram.createDiagram((SessionContext)context, (String)"2e8f8d52-dc83-45a2-b64c-31e676486b4c", (String)"Missions Capabilities Blank");
        this.capability1 = diagram.createCapability();
        this.capability2 = diagram.createCapability();
        this.actor1 = diagram.createActor();
        this.mission1 = diagram.createMission();
        this.mission2 = diagram.createMission();
    }

    protected void createLogicalArchitecture(SessionContext context) {
        CapabilityDiagram diagram = CapabilityDiagram.createDiagram((SessionContext)context, (String)"d89e7f00-8f98-4a05-a9ee-930307efee73", (String)"Capability Realization Blank");
        this.capability1 = diagram.createCapability();
        this.capability2 = diagram.createCapability();
        this.actor1 = diagram.createActor();
    }

    protected void createPhysicalArchitecture(SessionContext context) {
        CapabilityDiagram diagram = CapabilityDiagram.createDiagram((SessionContext)context, (String)"b02dd33a-ffa1-47fa-96dc-fa0863aab9ee", (String)"Capability Realization Blank");
        this.capability1 = diagram.createCapability();
        this.capability2 = diagram.createCapability();
        this.actor1 = diagram.createActor();
    }

    public static Test suite() {
        return new InsertRemoveScenario();
    }
}

