/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.sequence;

import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.FSDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.tools.ju.sequence.SequenceTest;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.framework.model.GenericModel;

public class CreateFunctionalExchange
extends SequenceTest {
    public void test() throws Exception {
        BlockArchitectureExt.Type[] types = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.OA, BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        this.testOnAllLevels(types, SequenceTest.SequenceType.ES);
        this.testOnAllLevels(types, SequenceTest.SequenceType.FS);
    }

    @Override
    public void test(SequenceDiagram diagram) {
        this.setUpDiagram(diagram);
        this.testCreateFunctionalExchange(diagram);
        this.testCreateFunctionalExchangeWithReturnBranch(diagram);
    }

    @Override
    public void setUpDiagram(SequenceDiagram diagram) {
        super.setUpDiagram(diagram);
        BlockArchitectureExt.Type type = diagram.getDiagramBlockArchitecture();
        SkeletonHelper.createFunctionalExchange((String)this.getRootFunctionId(type), (String)GenericModel.FUNCTIONAL_EXCHANGE_1, (SessionContext)diagram.getSessionContext());
        SkeletonHelper.createFunctionalExchange((String)this.getRootFunctionId(type), (String)GenericModel.FUNCTIONAL_EXCHANGE_4, (SessionContext)diagram.getSessionContext());
        if (type != BlockArchitectureExt.Type.SA) {
            SkeletonHelper.createFunctionalExchange((String)this.getRootFunctionId(type), (String)GenericModel.FUNCTIONAL_EXCHANGE_2, (SessionContext)diagram.getSessionContext());
            SkeletonHelper.createFunctionalExchange((String)this.getRootFunctionId(type), (String)GenericModel.FUNCTIONAL_EXCHANGE_3, (SessionContext)diagram.getSessionContext());
            SkeletonHelper.createFunctionalExchange((String)this.getRootFunctionId(type), (String)GenericModel.FUNCTIONAL_EXCHANGE_5, (SessionContext)diagram.getSessionContext());
            SkeletonHelper.createFunctionalExchange((String)this.getRootFunctionId(type), (String)GenericModel.FUNCTIONAL_EXCHANGE_6, (SessionContext)diagram.getSessionContext());
        }
    }

    protected void testCreateFunctionalExchange(SequenceDiagram diagram) {
        BlockArchitectureExt.Type type = diagram.getDiagramBlockArchitecture();
        if (diagram instanceof FSDiagram) {
            diagram.createFunctionalExchange(GenericModel.FUNCTIONAL_EXCHANGE_1, this.function1, this.function2);
        } else {
            diagram.createFunctionalExchange(GenericModel.FUNCTIONAL_EXCHANGE_1, this.actor1, this.actor2);
            if (type != BlockArchitectureExt.Type.SA) {
                diagram.createFunctionalExchange(GenericModel.FUNCTIONAL_EXCHANGE_2, this.actor1, this.component1);
                diagram.createFunctionalExchange(GenericModel.FUNCTIONAL_EXCHANGE_3, this.component1, this.component2);
            }
        }
    }

    protected void testCreateFunctionalExchangeWithReturnBranch(SequenceDiagram diagram) {
        BlockArchitectureExt.Type type = diagram.getDiagramBlockArchitecture();
        if (diagram instanceof FSDiagram) {
            diagram.createFunctionalExchange(GenericModel.FUNCTIONAL_EXCHANGE_4, this.function1, this.function2);
        } else {
            diagram.createFunctionalExchangeWithReturnBranch(GenericModel.FUNCTIONAL_EXCHANGE_4, this.actor1, this.actor2);
            if (type != BlockArchitectureExt.Type.SA) {
                diagram.createFunctionalExchangeWithReturnBranch(GenericModel.FUNCTIONAL_EXCHANGE_5, this.actor1, this.component1);
                diagram.createFunctionalExchangeWithReturnBranch(GenericModel.FUNCTIONAL_EXCHANGE_6, this.component1, this.component2);
            }
        }
    }
}

