/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.sequence;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.model.helpers.StateMachineExt;
import org.polarsys.capella.test.diagram.common.ju.context.FSDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.MSMDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.tools.ju.sequence.SequenceTest;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class InsertInvolvedStatesAndModes
extends SequenceTest {
    public void test() throws Exception {
        BlockArchitectureExt.Type[] types = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.OA, BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        BlockArchitectureExt.Type[] typesIS = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        this.testOnAllLevels(types, SequenceTest.SequenceType.ES);
        this.testOnAllLevels(typesIS, SequenceTest.SequenceType.IS);
        this.testOnAllLevels(types, SequenceTest.SequenceType.FS);
    }

    @Override
    public void test(SequenceDiagram diagram) {
        this.setUpDiagram(diagram);
        if (diagram instanceof FSDiagram) {
            this.testInsertInvolvedStatesAndModes(diagram, this.function1);
        } else {
            this.testInsertInvolvedStatesAndModes(diagram, this.actor1);
        }
    }

    protected void testInsertInvolvedStatesAndModes(SequenceDiagram diagram, String containerId) {
        diagram.insertState(containerId, GenericModel.STATE_1);
        diagram.insertState(containerId, GenericModel.STATE_2);
    }

    @Override
    public void setUpDiagram(SequenceDiagram diagram) {
        if (diagram instanceof FSDiagram) {
            this.function1 = ((FSDiagram)diagram).createFunction();
        } else {
            this.actor1 = diagram.createActor();
        }
        this.addStateMachineRegion(this.actor1, "StateMachine1");
        AbstractType type = ScenarioExt.getAbstractType((EObject)this.context.getSemanticElement(this.actor1));
        Region region = StateMachineExt.getFirstStateMachinesRegion((Component)((Component)type));
        MSMDiagram msm = MSMDiagram.createDiagram((SessionContext)this.context, (String)region.getId());
        MSMDiagram.setUnsynchronized((MSMDiagram)msm);
        this.context.setPreference("MSManagement.ModeStateMixed.Allowed", false);
        msm.createState(msm.getDiagramId(), GenericModel.STATE_1);
        msm.createState(msm.getDiagramId(), GenericModel.STATE_2);
    }

    private void addStateMachineRegion(String elementId, String smName) {
        AbstractType type = ScenarioExt.getAbstractType((EObject)this.context.getSemanticElement(elementId));
        if (type instanceof Block) {
            this.addStateMachineRegion((Block)type, smName);
        }
    }

    private void addStateMachineRegion(final Block block, final String smName) {
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                StateMachine sm = CapellacommonFactory.eINSTANCE.createStateMachine(smName);
                block.getOwnedStateMachines().add((Object)sm);
                Region defaultRegion = null;
                Iterator iterator = sm.getOwnedRegions().iterator();
                while (iterator.hasNext()) {
                    Region region;
                    defaultRegion = region = (Region)iterator.next();
                }
                if (defaultRegion == null) {
                    defaultRegion = CapellacommonFactory.eINSTANCE.createRegion("Default Region");
                    sm.getOwnedRegions().add((Object)defaultRegion);
                }
            }
        };
        this.context.getExecutionManager().execute((ICommand)cmd);
    }
}

