/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.sequence;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.FSDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.tools.ju.sequence.SequenceTest;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.framework.model.GenericModel;

public class InsertRemoveExchangeContext
extends SequenceTest {
    String seqMsg = "SequenceMessage";
    String constraint = GenericModel.CONSTRAINT_1;

    public void test() throws Exception {
        BlockArchitectureExt.Type[] types = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.OA, BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        BlockArchitectureExt.Type[] typesIS = new BlockArchitectureExt.Type[]{BlockArchitectureExt.Type.SA, BlockArchitectureExt.Type.LA, BlockArchitectureExt.Type.PA};
        this.testOnAllLevels(types, SequenceTest.SequenceType.ES);
        this.testOnAllLevels(typesIS, SequenceTest.SequenceType.IS);
        this.testOnAllLevels(types, SequenceTest.SequenceType.FS);
    }

    @Override
    public void test(SequenceDiagram diagram) {
        this.setUpDiagram(diagram);
        diagram.insertExchangeContext(this.constraint);
    }

    @Override
    public void setUpDiagram(SequenceDiagram diagram) {
        String source = "";
        String target = "";
        if (diagram instanceof FSDiagram) {
            source = ((FSDiagram)diagram).createFunction();
            target = ((FSDiagram)diagram).createFunction();
        } else {
            source = diagram.createActor();
            target = diagram.createActor();
        }
        SkeletonHelper.createSequenceMessage((String)((Scenario)diagram.getDiagramDescriptor().getTarget()).getId(), (String)this.seqMsg, (String)source, (String)target, (SessionContext)this.context);
        diagram.createConstraint(this.constraint);
        this.addConstraint(this.seqMsg, this.constraint);
        diagram.removeConstraint(this.constraint, diagram.getDiagramId());
    }

    private void addConstraint(String elementId, final String constraintId) {
        EObject obj = this.context.getSemanticElement(elementId);
        if (obj instanceof SequenceMessage) {
            final SequenceMessage msg = (SequenceMessage)obj;
            AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                public void run() {
                    Constraint c = (Constraint)InsertRemoveExchangeContext.this.context.getSemanticElement(constraintId);
                    msg.setExchangeContext(c);
                }
            };
            this.context.getExecutionManager().execute((ICommand)cmd);
        }
    }
}

