/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class CreatePhysicalPath
extends EmptyProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnActors(context, "b121dd59-9d3f-4c21-94ae-87e957aaa2a9", "148f62ef-77db-48f3-becd-eb9de464a9d3");
        this.testOnActors(context, "32f06455-48c7-4d68-aea5-cf397ab4aff2", "ca2e0d95-cba7-4606-8734-00c23f117ce8");
        this.testOnPhysicalActors(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        this.testOnActorsOnly(context, "826533be-e00c-468d-a47e-ba3ee51b4d35", "b121dd59-9d3f-4c21-94ae-87e957aaa2a9");
        this.testOnActorsOnly(context, "a59425f8-6827-48eb-ab41-cbf7e4d7674b", "32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.testOnActorsOnly(context, "9a842ee5-662a-4534-a70a-d9241779d0ba", "16953dc7-be25-45ef-9da9-32869d0cb53f");
        this.testOnActorsOnly(context, "b121dd59-9d3f-4c21-94ae-87e957aaa2a9", "b121dd59-9d3f-4c21-94ae-87e957aaa2a9");
        this.testOnActorsOnly(context, "32f06455-48c7-4d68-aea5-cf397ab4aff2", "32f06455-48c7-4d68-aea5-cf397ab4aff2");
        this.testOnActorsOnly(context, "16953dc7-be25-45ef-9da9-32869d0cb53f", "16953dc7-be25-45ef-9da9-32869d0cb53f");
    }

    private void testOnActorsOnly(SessionContext context, String idSource, String defaultContainer) {
        EObject target = context.getSemanticElement(idSource);
        XABDiagram xab = XABDiagram.createDiagram((SessionContext)context, (String)idSource);
        xab.createActor(GenericModel.LA_1);
        xab.createActor(GenericModel.LA_2);
        xab.createActor(GenericModel.LA_3);
        xab.createPhysicalLink(GenericModel.LA_1, GenericModel.LA_2, GenericModel.CL_1);
        xab.createPhysicalLink(GenericModel.LA_2, GenericModel.LA_3, GenericModel.CL_2);
        PhysicalPath path = xab.createPhysicalPath(GenericModel.PATH_1, new String[]{GenericModel.CL_1, GenericModel.CL_2});
        if (target instanceof ComponentPkg) {
            CreatePhysicalPath.assertTrue((String)"Path shall be created into System as it can't be container into diagram target", (path.eContainer() == context.getSemanticElement(defaultContainer) ? 1 : 0) != 0);
        } else if (target instanceof Component) {
            CreatePhysicalPath.assertTrue((String)"Path shall be created into diagram target as it is a container", (path.eContainer() == context.getSemanticElement(idSource) ? 1 : 0) != 0);
        }
        xab.createActor(GenericModel.LA_1_1, GenericModel.LA_1);
        xab.createActor(GenericModel.LA_1_2, GenericModel.LA_1);
        xab.createActor(GenericModel.LA_1_3, GenericModel.LA_1);
        xab.createPhysicalLink(GenericModel.LA_1_1, GenericModel.LA_1_2, GenericModel.CL_3);
        xab.createPhysicalLink(GenericModel.LA_1_2, GenericModel.LA_1_3, GenericModel.CL_4);
        PhysicalPath path2 = xab.createPhysicalPath(GenericModel.PATH_2, new String[]{GenericModel.CL_3, GenericModel.CL_4});
        Component actor = (Component)((Part)context.getSemanticElement(GenericModel.LA_1)).getAbstractType();
        CreatePhysicalPath.assertTrue((String)"Path shall be created into Common ancestor", (path2.eContainer() == actor ? 1 : 0) != 0);
    }

    protected void testOnPhysicalActors(SessionContext context, String idSource) {
        PABDiagram xab = PABDiagram.createDiagram((SessionContext)context, (String)idSource);
        xab.createNodeComponent(GenericModel.NODE_1, xab.getDiagramId());
        xab.createActor(GenericModel.LA_1);
        xab.createActor(GenericModel.LA_2);
        xab.createPhysicalLink(GenericModel.NODE_1, GenericModel.LA_1, GenericModel.CL_1);
        xab.createPhysicalLink(GenericModel.LA_1, GenericModel.LA_2, GenericModel.CL_2);
        xab.hasView(GenericModel.LA_1);
        xab.hasView(GenericModel.LA_2);
        xab.createPhysicalPath(GenericModel.PATH_1, new String[]{GenericModel.CL_1, GenericModel.CL_2});
    }

    protected void testOnActors(SessionContext context, String idSource, String idSystem) {
        XABDiagram xab = XABDiagram.createDiagram((SessionContext)context, (String)idSource);
        if (xab.getView(idSystem) == null) {
            xab.insertComponent(idSystem, xab.getDiagramId());
        }
        xab.createActor(GenericModel.LA_1);
        xab.createActor(GenericModel.LA_2);
        xab.createPhysicalLink(idSystem, GenericModel.LA_1, GenericModel.CL_1);
        xab.createPhysicalLink(GenericModel.LA_1, GenericModel.LA_2, GenericModel.CL_2);
        xab.hasView(GenericModel.LA_1);
        xab.hasView(GenericModel.LA_2);
        xab.createPhysicalPath(GenericModel.PATH_1, new String[]{GenericModel.CL_1, GenericModel.CL_2});
    }
}

