/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.OABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public class DragAndDropTest
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        this.testOnXAB(context, "[SAB] System", BlockArchitectureExt.Type.SA, "b4fd3a2f-a53d-4da7-bec4-8fd7169d2caa");
        this.testOnXAB(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "8dae69b8-87f7-45c0-9f95-f72009aa4c1c");
        this.testOnXAB(context, "[PAB] Physical System", BlockArchitectureExt.Type.PA, "6117356a-8b31-480f-a1ed-07e8da164fbd");
        this.testOnOAB(context, "[OAB] Operational Context", BlockArchitectureExt.Type.OA, "64605af7-0cfd-47f4-99ef-0c0afa52304e");
    }

    public void testOnXAB(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String targetId) {
        String constraint1;
        String targetviewId;
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        String actor1 = diagram.createActor(GenericModel.ACTOR_1);
        String function1 = diagram.createFunction(GenericModel.FUNCTION_1, actor1);
        String actor2 = diagram.createActor(GenericModel.ACTOR_2);
        diagram.dragAndDropAbstractFunctionallocation(function1, actor2);
        if (type == BlockArchitectureExt.Type.LA) {
            String component1 = diagram.createComponent(GenericModel.COMPONENT_1, "6b64bc6d-7666-4202-8727-bb039a76d172");
            String component2 = diagram.createComponent(GenericModel.COMPONENT_2, "6b64bc6d-7666-4202-8727-bb039a76d172");
            diagram.dragAndDropComponent(component2, component1);
            targetviewId = "6b64bc6d-7666-4202-8727-bb039a76d172";
            diagram.dragAndDropComponent(actor1, targetviewId);
            diagram.dragAndDropComponent(actor1, diagram.getDiagramId());
        }
        if (type != BlockArchitectureExt.Type.OA) {
            String actor3 = diagram.createActor(GenericModel.ACTOR_3);
            diagram.createPhysicalLink(actor1, actor3, GenericModel.LA_1);
            Part partActor1Obj = (Part)diagram.getSessionContext().getSemanticElement(actor1);
            Component actor1Obj = (Component)partActor1Obj.getAbstractType();
            PhysicalPort physicalPort = (PhysicalPort)actor1Obj.getOwnedFeatures().iterator().next();
            diagram.dragAndDropPhysicalPort(physicalPort.getId(), actor2);
            diagram.createComponentExchange(actor1, actor3, GenericModel.LA_2);
            ComponentPort compPort = (ComponentPort)actor1Obj.getOwnedFeatures().iterator().next();
            diagram.dragAndDropComponentPort(compPort.getId(), actor2);
            String function1Id = diagram.createFunction(GenericModel.FUNCTION_1, actor3);
            String function2Id = diagram.createFunction(GenericModel.FUNCTION_2, actor3);
            String function3Id = diagram.createFunction(GenericModel.FUNCTION_3, actor3);
            diagram.createFunctionalExchange(function1Id, function3Id, GenericModel.FUNCTIONAL_EXCHANGE_1);
            AbstractFunction f1 = (AbstractFunction)diagram.getSessionContext().getSemanticElement(function1Id);
            EList ownedPins = f1.getOutputs();
            FunctionOutputPort outPort = (FunctionOutputPort)ownedPins.iterator().next();
            diagram.dragAndDropFunctionPort(outPort.getId(), function2Id);
        }
        if (type == BlockArchitectureExt.Type.PA) {
            PABDiagram pabDiagram = PABDiagram.createDiagram((SessionContext)context, (String)targetId);
            pabDiagram.createBehaviorComponent(GenericModel.BEHAVIOR_PC_1_1, pabDiagram.getDiagramId());
            pabDiagram.createDeployedBehaviorComponent(GenericModel.DEPLOY_BEHAVIOR_PC_1, GenericModel.BEHAVIOR_PC_1_1);
            pabDiagram.createBehaviorComponent(GenericModel.BEHAVIOR_PC_1_2, pabDiagram.getDiagramId());
            pabDiagram.createDeployedBehaviorComponent(GenericModel.DEPLOY_BEHAVIOR_PC_1_2_1, GenericModel.BEHAVIOR_PC_1_2);
            pabDiagram.dragAndDropDeployment(GenericModel.DEPLOY_BEHAVIOR_PC_1_2_1, GenericModel.BEHAVIOR_PC_1_1);
            constraint1 = pabDiagram.createConstraint(GenericModel.CONSTRAINT_1);
            diagram.dragAndDropConstraintsFromExplorer(constraint1, diagram.getDiagramId());
            targetviewId = pabDiagram.dragAndDropComponentsFromExplorer(targetId, pabDiagram.getDiagramId());
            String pabactor1 = pabDiagram.createActor("actor1");
            pabDiagram.dragAndDropComponent(pabactor1, targetviewId);
            pabDiagram.dragAndDropComponent(pabactor1, pabDiagram.getDiagramId());
            pabDiagram.dragAndDropComponent(pabactor1, targetviewId);
        } else {
            XABDiagram diagramSetup = XABDiagram.createDiagram((SessionContext)context, (String)targetId);
            constraint1 = diagramSetup.createConstraint(GenericModel.CONSTRAINT_1);
            diagram.dragAndDropConstraintsFromExplorer(constraint1, diagram.getDiagramId());
        }
        String actor4 = diagram.createActor(GenericModel.ACTOR_4);
        String actor5 = diagram.createActor(GenericModel.ACTOR_5);
        String actor6 = diagram.createActor(GenericModel.ACTOR_5, actor4);
        diagram.dragAndDropComponent(actor5, actor4);
        diagram.dragAndDropComponent(actor5, diagram.getDiagramId());
        diagram.dragAndDropComponent(actor5, actor6);
        diagram.dragAndDropComponent(actor5, actor4);
        diagram.dragAndDropComponent(actor5, actor6);
    }

    public void testOnOAB(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String targetId) {
        OABDiagram diagram = OABDiagram.openDiagram((SessionContext)context, (String)diagramName);
        OABDiagram diagramSetup = OABDiagram.createDiagram((SessionContext)context, (String)targetId);
        String containerId = diagram.getDiagramId();
        String actor1 = diagram.createActor(GenericModel.ACTOR_1);
        String function1 = diagram.createFunction(GenericModel.FUNCTION_1, actor1);
        String actor2 = diagram.createActor(GenericModel.ACTOR_2);
        diagram.dragAndDropAbstractFunctionallocation(function1, actor2);
        String entity1 = diagram.createComponent(GenericModel.ENTITY_1, containerId);
        String entity2 = diagram.createComponent(GenericModel.ENTITY_2, containerId);
        diagram.dragAndDropComponent(entity2, entity1);
        diagram.dragAndDropComponent(actor1, entity1);
        diagram.dragAndDropComponent(actor1, entity2);
        diagram.dragAndDropComponent(actor1, diagram.getDiagramId());
        diagram.dragAndDropComponent(actor1, entity2);
        String entity3 = diagramSetup.createComponent(GenericModel.ENTITY_3, diagramSetup.getDiagramId());
        String role1 = diagramSetup.createRole(GenericModel.ROLE_1_1_3, entity3);
        String operationalActivity1 = diagramSetup.createFunction(GenericModel.FUNCTION_2, entity3);
        String operationalActivity2 = diagramSetup.createFunction(GenericModel.FUNCTION_2, entity3);
        diagram.dragAndDropOperationalActivitiesFromExplorer(operationalActivity1, entity1);
        diagram.dragAndDropRolesFromExplorer(role1, entity1);
        diagram.dragAndDropOperationalActivitiesFromExplorerToRole(operationalActivity2, role1);
        String constraint1 = diagramSetup.createConstraint(GenericModel.CONSTRAINT_1);
        diagram.dragAndDropConstraintsFromExplorer(constraint1, diagram.getDiagramId());
    }
}

