/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.queries.QueryIdentifierConstants;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class ReuseActors
extends XABDiagramsProject {
    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        String[] saReuseIds = new String[]{"afe019b9-2e81-4363-b09c-1e106b7ca7b4", "fecd3e88-fe49-44b0-a6d2-cfc76af572a2"};
        String[] laReuseIds = new String[]{"dc2c6c0f-a55b-431c-a739-79fbd2d243c9", "50574f2c-7b5f-4b8b-b0eb-37126f10dbc4"};
        this.testOnXAB(context, "[SAB] System", BlockArchitectureExt.Type.SA, saReuseIds);
        this.testOnXAB(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, laReuseIds);
        this.testOnComponent(context, "[SAB] System", "ff952c1b-4605-414e-892b-7fc1e0886826", BlockArchitectureExt.Type.SA, "fecd3e88-fe49-44b0-a6d2-cfc76af572a2", "ef5e2fd0-52eb-4dc2-a11e-4d669be1a396", "d2d00d4d-3eb6-4198-b7d7-55360f583e37");
        this.testOnComponent(context, "[LAB] Logical System", "e7884bff-642d-44ac-bce6-c3cd20aa03b1", BlockArchitectureExt.Type.LA, "50574f2c-7b5f-4b8b-b0eb-37126f10dbc4", "5a0a0053-6a38-40ef-a6a2-029062a6c5f8", "4df2b99f-9a2a-4e5f-8a4c-a9a60804495e", "9c86e140-d4f0-4321-b026-bc4effb6c5c2", "a2673077-7c94-4e97-8261-a9c676aa4b79", "09441ac0-4fa8-42c6-8c73-a27d6602b8ed", "68df53da-c1cc-402c-b8ec-54080384ac5c");
    }

    public void testOnXAB(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String ... reuseIds) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        context.setReusableComponents("829c7043-54c5-42f4-807d-18f8ca504130");
        diagram.reuseActor(diagram.getDiagramId(), reuseIds);
        context.setSingletonComponents("829c7043-54c5-42f4-807d-18f8ca504130");
    }

    public void testOnComponent(SessionContext context, String diagramName, String partId, BlockArchitectureExt.Type type, String ... reuseIds) {
        Part part = (Part)context.getSemanticElement(partId);
        List actorsToInsert = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_AB_INSERT_ACTOR_FOR_LIB, (Object)part.getAbstractType());
        ReuseActors.assertTrue((actorsToInsert.size() == reuseIds.length ? 1 : 0) != 0);
        List actorIds = actorsToInsert.stream().map(Component.class::cast).map(actor -> actor.getId()).collect(Collectors.toList());
        String[] stringArray = reuseIds;
        int n = reuseIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            ReuseActors.assertTrue((boolean)actorIds.contains(id));
            ++n2;
        }
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        context.setReusableComponents("829c7043-54c5-42f4-807d-18f8ca504130");
        diagram.reuseActor(partId, reuseIds);
        context.setSingletonComponents("829c7043-54c5-42f4-807d-18f8ca504130");
    }
}

