/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.queries.QueryIdentifierConstants;
import org.polarsys.capella.test.diagram.common.ju.context.PABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.xab.XABDiagramsProject;
import org.polarsys.capella.test.framework.context.SessionContext;

public class ReuseComponents
extends XABDiagramsProject {
    private static final String NODE = "NODE";
    private static final String BEHAVIOUR = "BEHAVIOUR";

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        String[] laReuseIds = new String[]{"f8d17c52-5dd0-412d-8f45-cebd58928da0"};
        this.testOnXAB(context, "[LAB] Logical System", BlockArchitectureExt.Type.LA, "6b64bc6d-7666-4202-8727-bb039a76d172", laReuseIds);
        this.testOnPAB(context, "[PAB] Physical System", NODE, "[PAB] Physical System", "0cbac486-3671-45dd-890b-c04d4b226bc6");
        this.testOnPAB(context, "[PAB] Physical System", BEHAVIOUR, "[PAB] Physical System", "e6934a0a-bc02-4b96-ae58-cf0fdd326e58");
        this.testOnComponent(context, "[LAB] Logical System", "c30f774e-9dd2-406e-a611-14f59ebcb96c", BlockArchitectureExt.Type.LA, "d4822e98-c68c-4e29-a795-3df5fa98cca9");
        this.testOnComponent(context, "[PAB] Physical System", "79a754d4-99a4-4c7f-857d-aec9c0388232", BlockArchitectureExt.Type.PA, "850157c3-5c8f-4c6a-a1bf-29bb146c03cc", "b8c583bc-5409-4891-9779-552839d3cc6f", "630a2f89-79c9-4b00-8851-5f71ef48b740", "e6934a0a-bc02-4b96-ae58-cf0fdd326e58", "7af9dc10-385f-4b61-97b8-4f4a1a88e700");
    }

    public void testOnXAB(SessionContext context, String diagramName, BlockArchitectureExt.Type type, String containerId, String ... reuseIds) {
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        context.setReusableComponents("829c7043-54c5-42f4-807d-18f8ca504130");
        diagram.reuseComponent(containerId, reuseIds);
        context.setSingletonComponents("829c7043-54c5-42f4-807d-18f8ca504130");
    }

    public void testOnPAB(SessionContext context, String diagramName, String type, String containerId, String ... reuseIds) {
        PABDiagram diagram = PABDiagram.openDiagram((SessionContext)context, (String)diagramName);
        context.setReusableComponents("829c7043-54c5-42f4-807d-18f8ca504130");
        if (NODE.equals(type)) {
            diagram.reuseNodeComponent(containerId, reuseIds);
        } else if (BEHAVIOUR.equals(type)) {
            diagram.reuseBehaviourComponent(containerId, reuseIds);
        }
        context.setSingletonComponents("829c7043-54c5-42f4-807d-18f8ca504130");
    }

    public void testOnComponent(SessionContext context, String diagramName, String partId, BlockArchitectureExt.Type type, String ... reuseIds) {
        Part part = (Part)context.getSemanticElement(partId);
        List componentsToInsert = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_AB_INSERT_COMPONENT_FOR_LIB, (Object)part.getAbstractType());
        ReuseComponents.assertTrue((componentsToInsert.size() == reuseIds.length ? 1 : 0) != 0);
        List componentIds = componentsToInsert.stream().map(Component.class::cast).map(component -> component.getId()).collect(Collectors.toList());
        String[] stringArray = reuseIds;
        int n = reuseIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            ReuseComponents.assertTrue((boolean)componentIds.contains(id));
            ++n2;
        }
        XABDiagram diagram = XABDiagram.openDiagram((SessionContext)context, (String)diagramName, (BlockArchitectureExt.Type)type);
        context.setReusableComponents("829c7043-54c5-42f4-807d-18f8ca504130");
        diagram.reuseComponent(partId, reuseIds);
        context.setSingletonComponents("829c7043-54c5-42f4-807d-18f8ca504130");
    }
}

