/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xab.showhide.functions;

import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LineStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.model.GenericModel;

public abstract class AbstractShowHideFunctions
extends EmptyProject {
    protected void createComponent(XABDiagram xab, String componentId, String containerId) {
        xab.createComponent(componentId, containerId);
    }

    protected void insertComponent(XABDiagram xab, String id, String containerId) {
        xab.insertComponent(id, containerId);
    }

    protected void removeComponent(XABDiagram xab, String id, String containerId) {
        xab.removeComponent(id, containerId);
    }

    protected void testCommonScenarios(SessionContext context, String rootSF, String rootCPS) {
        this.testLeafFunctionInComponent(context, rootSF, rootCPS);
        this.testLeafFunctionInParentComponent(context, rootSF, rootCPS);
        this.testParentFunctionInComponent(context, rootSF, rootCPS);
        this.testParentFunctionInParentComponent(context, rootSF, rootCPS);
        this.testFunctionsMustHideIfShowSubComponent(context, rootSF, rootCPS);
    }

    protected void initialize(SessionContext context, String rootSF, String rootCPS) {
        this.initializeXDFB(context, rootSF, rootCPS);
        this.initializeXAB(context, rootSF, rootCPS);
    }

    protected XDFBDiagram initializeXDFB(SessionContext context, String rootSF, String rootCPS) {
        XDFBDiagram xdfb = XDFBDiagram.createDiagram((SessionContext)context, (String)rootSF);
        xdfb.createFunction(GenericModel.FUNCTION_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_1, GenericModel.FUNCTION_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_1_1, GenericModel.FUNCTION_1_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_1_2, GenericModel.FUNCTION_1_1);
        xdfb.createFunction(GenericModel.FUNCTION_1_2, GenericModel.FUNCTION_1);
        return xdfb;
    }

    protected XABDiagram initializeXAB(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = XABDiagram.createDiagram((SessionContext)context, (String)rootCPS);
        xab.clearDiagram();
        this.createComponent(xab, GenericModel.COMPONENT_1, xab.getDiagramId());
        this.createComponent(xab, GenericModel.COMPONENT_1_1, GenericModel.COMPONENT_1);
        this.createComponent(xab, GenericModel.COMPONENT_1_1_1, GenericModel.COMPONENT_1_1);
        this.createComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        xab.manageAllocatedFunction(GenericModel.FUNCTION_1_1_1, GenericModel.COMPONENT_1_1_1);
        xab.manageAllocatedFunction(GenericModel.FUNCTION_1_1_2, GenericModel.COMPONENT_1_1_1);
        xab.manageAllocatedFunction(GenericModel.FUNCTION_1_2, GenericModel.COMPONENT_1_2);
        return xab;
    }

    protected XABDiagram setUpDiagram(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = XABDiagram.createDiagram((SessionContext)context, (String)rootCPS);
        xab.clearDiagram();
        this.insertComponent(xab, GenericModel.COMPONENT_1, xab.getDiagramId());
        this.insertComponent(xab, GenericModel.COMPONENT_1_1, GenericModel.COMPONENT_1);
        this.insertComponent(xab, GenericModel.COMPONENT_1_1_1, GenericModel.COMPONENT_1_1);
        this.insertComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        return xab;
    }

    protected void testLeafFunctionInComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        xab.hasntView(GenericModel.FUNCTION_1_1_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_2);
        xab.hasntView(GenericModel.FUNCTION_1_2);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_1, GenericModel.COMPONENT_1_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_2, GenericModel.COMPONENT_1_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_2, GenericModel.COMPONENT_1_2);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_1, false, false);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_2, false, false);
        this.checkFunction(xab, GenericModel.FUNCTION_1_2, false, false);
    }

    protected void testLeafFunctionInParentComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        this.removeComponent(xab, GenericModel.COMPONENT_1_1_1, GenericModel.COMPONENT_1_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_2);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_1, GenericModel.COMPONENT_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_2, GenericModel.COMPONENT_1_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_1, false, true);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_2, false, true);
        this.removeComponent(xab, GenericModel.COMPONENT_1_1, GenericModel.COMPONENT_1);
        this.removeComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_1);
        xab.hasntView(GenericModel.FUNCTION_1_1_2);
        xab.hasntView(GenericModel.FUNCTION_1_2);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_1, GenericModel.COMPONENT_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1_2, GenericModel.COMPONENT_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_2, GenericModel.COMPONENT_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_1, false, true);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1_2, false, true);
        this.checkFunction(xab, GenericModel.FUNCTION_1_2, false, true);
    }

    protected void testParentFunctionInComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        xab.hasntView(GenericModel.FUNCTION_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1, GenericModel.COMPONENT_1_1_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1, true, false);
    }

    protected void testParentFunctionInParentComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        this.removeComponent(xab, GenericModel.COMPONENT_1_1_1, GenericModel.COMPONENT_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1, GenericModel.COMPONENT_1_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1, true, true);
        this.removeComponent(xab, GenericModel.COMPONENT_1_1, GenericModel.COMPONENT_1);
        xab.hasntView(GenericModel.FUNCTION_1_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_1, GenericModel.COMPONENT_1);
        this.checkFunction(xab, GenericModel.FUNCTION_1_1, true, true);
    }

    protected void testFunctionsMustHideIfShowSubComponent(SessionContext context, String rootSF, String rootCPS) {
        XABDiagram xab = this.setUpDiagram(context, rootSF, rootCPS);
        this.removeComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        xab.insertAllocatedFunction(GenericModel.FUNCTION_1_2, GenericModel.COMPONENT_1);
        this.insertComponent(xab, GenericModel.COMPONENT_1_2, GenericModel.COMPONENT_1);
        xab.hasntView(GenericModel.FUNCTION_1_2);
    }

    protected void checkFunction(XABDiagram xab, String id, boolean mustBeItalic, boolean mustBeDash) {
        DSemanticDecorator view = xab.getView(id);
        if (view instanceof DNode) {
            DNode node = (DNode)view;
            NodeStyle style = node.getOwnedStyle();
            LineStyle lineStyle = style.getBorderLineStyle();
            boolean isDash = "dash".equals(lineStyle.getLiteral());
            AbstractShowHideFunctions.assertEquals((boolean)mustBeDash, (boolean)isDash);
            boolean isItalic = false;
            EList labelFormat = style.getLabelFormat();
            for (FontFormat format : labelFormat) {
                if (!"italic".equals(format.getLiteral())) continue;
                isItalic = true;
            }
            AbstractShowHideFunctions.assertEquals((boolean)mustBeItalic, (boolean)isItalic);
        } else {
            AbstractShowHideFunctions.fail();
        }
    }
}

