/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xdfb;

import java.util.Arrays;
import java.util.List;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.test.diagram.common.ju.api.AbstractDiagramTestCase;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.framework.context.SessionContext;

public class FunctionalChainCycleDetection
extends AbstractDiagramTestCase {
    private static final String MODEL_NAME = "opd-fcd-cycle-model";
    public static final String SDFB_A = "_bVwWA7FGEeqoD5VLzCQ3nw";
    public static final String SDFB_A_INVALID_CYCLE = "_iy6sGrFGEeqoD5VLzCQ3nw";
    public static final String SDFB_B = "__nnmo7FGEeqoD5VLzCQ3nw";
    public static final String SDFB_B_INVALID_CYCLE = "_Ls3k1rFLEeqoD5VLzCQ3nw";
    public static final String SDFB_DEEP = "_ho84wLFOEeq-EJ4697_U6Q";

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext sessionContext = new SessionContext(session);
        List<String> validDiagramNames = Arrays.asList(SDFB_A, SDFB_B, SDFB_DEEP);
        List<String> invalidDiagramsNames = Arrays.asList(SDFB_A_INVALID_CYCLE, SDFB_B_INVALID_CYCLE);
        this.testFunctionalChainStatus(sessionContext, validDiagramNames, true);
        this.testFunctionalChainStatus(sessionContext, invalidDiagramsNames, false);
    }

    private void testFunctionalChainStatus(SessionContext sessionContext, List<String> diagramNames, boolean valid) {
        for (String name : diagramNames) {
            DiagramContext diagramContext = DiagramContext.getDiagram((SessionContext)sessionContext, (String)name);
            diagramContext.refreshDiagram();
            DDiagram diagram = diagramContext.getDiagram();
            DDiagramElement functionalChainElement = this.getFunctionalChainElement(diagram);
            FunctionalChainCycleDetection.assertNotNull((Object)functionalChainElement);
            FunctionalChain functionalChain = (FunctionalChain)functionalChainElement.getTarget();
            FunctionalChainCycleDetection.assertEquals((boolean)valid, (!FunctionalChainExt.containsACycle((FunctionalChain)functionalChain) ? 1 : 0) != 0);
            String functionalChainElementName = functionalChainElement.getName();
            FunctionalChainCycleDetection.assertEquals((boolean)valid, (!functionalChainElementName.contains("invalid") ? 1 : 0) != 0);
        }
    }

    private DDiagramElement getFunctionalChainElement(DDiagram diagram) {
        for (DDiagramElement element : diagram.getOwnedDiagramElements()) {
            if (!(element.getTarget() instanceof FunctionalChain)) continue;
            return element;
        }
        return null;
    }

    protected String getRequiredTestModel() {
        return MODEL_NAME;
    }
}

