/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.tools.ju.xfcd;

import java.util.Arrays;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.test.diagram.common.ju.context.XFCDDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.AbstractFunctionalChainToolTest;
import org.polarsys.capella.test.framework.context.SessionContext;

public abstract class AbstractMaxHierarchyLevel1Test
extends AbstractFunctionalChainToolTest {
    protected String EMPTYCHAIN1_DIAG;
    protected String LEVEL1CHAIN1;
    protected String LEVEL1CHAIN2;
    protected String FUNCTION_1;
    protected String FUNCTION_2;
    protected String FUNCTION_3;
    protected String EXCHANGE_2;

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        XFCDDiagram xfcd = XFCDDiagram.getDiagram((SessionContext)context, (String)this.EMPTYCHAIN1_DIAG);
        SessionContext sessionContext = xfcd.getSessionContext();
        String functionalChainReference1Id = xfcd.involveFunctionalChain(xfcd.getDiagramId(), this.LEVEL1CHAIN1);
        FunctionalChainReference functionalChainReference1 = (FunctionalChainReference)sessionContext.getSemanticElement(functionalChainReference1Id);
        FunctionalChain functionalChain1 = functionalChainReference1.getReferencedFunctionalChain();
        String functionalChainReference2Id = xfcd.involveFunctionalChain(xfcd.getDiagramId(), this.LEVEL1CHAIN2);
        FunctionalChainReference functionalChainReference2 = (FunctionalChainReference)sessionContext.getSemanticElement(functionalChainReference2Id);
        FunctionalChain functionalChain2 = functionalChainReference2.getReferencedFunctionalChain();
        String involvementFunction1Id = xfcd.involveFunction(functionalChain1.getId(), this.FUNCTION_1);
        String involvementFunction3Id = xfcd.involveFunction(functionalChain1.getId(), this.FUNCTION_3);
        String involvementFunction3BisId = xfcd.involveFunction(functionalChain2.getId(), this.FUNCTION_3);
        String involvementFunction2Id = xfcd.involveFunction(functionalChain2.getId(), this.FUNCTION_2);
        String connectionLink1Id = xfcd.connectFunctions(involvementFunction3Id, involvementFunction3BisId);
        FunctionalChainInvolvementLink connectionLink1 = (FunctionalChainInvolvementLink)sessionContext.getSemanticElement(connectionLink1Id);
        AbstractMaxHierarchyLevel1Test.assertEquals(Arrays.asList(functionalChainReference1), (Object)connectionLink1.getSourceReferenceHierarchy());
        AbstractMaxHierarchyLevel1Test.assertEquals(Arrays.asList(functionalChainReference2), (Object)connectionLink1.getTargetReferenceHierarchy());
        String exchangeLink2Id = xfcd.involveExchange(involvementFunction1Id, involvementFunction2Id, this.EXCHANGE_2);
        FunctionalChainInvolvementLink exchangeLink2 = (FunctionalChainInvolvementLink)sessionContext.getSemanticElement(exchangeLink2Id);
        AbstractMaxHierarchyLevel1Test.assertEquals(Arrays.asList(functionalChainReference1), (Object)exchangeLink2.getSourceReferenceHierarchy());
        AbstractMaxHierarchyLevel1Test.assertEquals(Arrays.asList(functionalChainReference2), (Object)exchangeLink2.getTargetReferenceHierarchy());
        String involvementFunction2OnDiagramId = xfcd.involveFunction(xfcd.getDiagramId(), this.FUNCTION_2);
        String exchangeLink3Id = xfcd.involveExchange(involvementFunction2OnDiagramId, involvementFunction3Id, this.EXCHANGE_2);
        FunctionalChainInvolvementLink exchangeLink3 = (FunctionalChainInvolvementLink)sessionContext.getSemanticElement(exchangeLink3Id);
        AbstractMaxHierarchyLevel1Test.assertTrue((boolean)exchangeLink3.getSourceReferenceHierarchy().isEmpty());
        AbstractMaxHierarchyLevel1Test.assertEquals(Arrays.asList(functionalChainReference1), (Object)exchangeLink3.getTargetReferenceHierarchy());
        String connectionLink3Id = xfcd.connectFunctions(involvementFunction2Id, involvementFunction2OnDiagramId);
        FunctionalChainInvolvementLink connectionLink3 = (FunctionalChainInvolvementLink)sessionContext.getSemanticElement(connectionLink3Id);
        AbstractMaxHierarchyLevel1Test.assertEquals(Arrays.asList(functionalChainReference2), (Object)connectionLink3.getSourceReferenceHierarchy());
        AbstractMaxHierarchyLevel1Test.assertTrue((boolean)connectionLink3.getTargetReferenceHierarchy().isEmpty());
    }
}

