/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.doc.ju;

import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.help.internal.server.WebappManager;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.polarsys.capella.test.doc.ju.StyleCheckTestCase;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class BrokenLinksCheckTestCase
extends BasicTestCase {
    public void test() throws Exception {
        Bundle[] bundles;
        WebappManager.start((String)"help");
        ArrayList<Bundle> docPlugins = new ArrayList<Bundle>();
        ArrayList<URL> invalidHtmls = new ArrayList<URL>();
        BundleContext ctx = FrameworkUtil.getBundle(StyleCheckTestCase.class).getBundleContext();
        Bundle[] bundleArray = bundles = ctx.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (this.isDocPlugin(bundle)) {
                docPlugins.add(bundle);
            }
            ++n2;
        }
        String errMsg = "The following documents contain broken links: ";
        for (Bundle docPlugin : docPlugins) {
            String bundleErrMsg = "In plugin " + docPlugin.getSymbolicName() + ": ";
            Enumeration entries = docPlugin.findEntries("html", "*.html", true);
            boolean hasInvalidHtml = false;
            while (entries.hasMoreElements()) {
                URL htmlURL = (URL)entries.nextElement();
                if (this.isExluded(htmlURL) || !this.containBrokenLinks(docPlugin, htmlURL)) continue;
                invalidHtmls.add(htmlURL);
                bundleErrMsg = String.valueOf(bundleErrMsg) + htmlURL.getFile() + ", ";
                hasInvalidHtml = true;
            }
            if (!hasInvalidHtml) continue;
            errMsg = String.valueOf(errMsg) + bundleErrMsg.substring(0, bundleErrMsg.length() - 2) + ". ";
        }
        BrokenLinksCheckTestCase.assertTrue((String)errMsg, (invalidHtmls.size() == 0 ? 1 : 0) != 0);
        WebappManager.stop((String)"help");
    }

    private String getHelpServer() {
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help/topic/";
    }

    protected boolean isDocPlugin(Bundle bundle) {
        return bundle.getSymbolicName().startsWith("org.polarsys.capella") && bundle.getSymbolicName().endsWith("doc");
    }

    public boolean containBrokenLinks(Bundle docPlugin, URL htmlURL) throws IOException {
        boolean result = false;
        String url = String.valueOf(this.getHelpServer()) + docPlugin.getSymbolicName() + htmlURL.getFile().replace(" ", "%20");
        System.out.println("Fetching..." + url);
        try {
            Document doc = Jsoup.connect((String)url).get();
            Elements links = doc.select("a[href]");
            for (Element link : links) {
                String linkURL = link.absUrl("href").replace(" ", "%20");
                try {
                    System.out.println("Checking link " + link.text());
                    Connection.Response response = Jsoup.connect((String)linkURL).ignoreContentType(true).execute();
                    System.out.println("\tOK with status code:" + response.statusCode());
                }
                catch (HttpStatusException e1) {
                    System.out.println("Found broken link: " + link.absUrl("href") + " with status code " + e1.getStatusCode());
                    result = true;
                }
                catch (UnknownHostException e2) {
                    System.out.println("Found broken link: " + link.absUrl("href") + " with unknown host");
                    result = true;
                }
            }
        }
        catch (HttpStatusException e) {
            System.out.println("Error while fetching " + url);
            result = true;
        }
        return result;
    }

    protected boolean isExluded(URL htmlURL) {
        return htmlURL.getFile().startsWith("/html/api-docs/javadoc");
    }

    protected boolean isInternalLink(String linkURL) {
        return linkURL.contains(WebappManager.getHost());
    }
}

