/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.fragmentation.ju.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.core.data.capellamodeller.util.CapellamodellerResourceImpl;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.fragmentation.ju.messages.FragmentationMessages;
import org.polarsys.capella.test.fragmentation.ju.utils.FragmentTest;
import org.polarsys.capella.test.fragmentation.ju.utils.FragmentUtils;
import org.polarsys.capella.test.fragmentation.ju.utils.NonAbusiveFragmentTest;
import org.polarsys.capella.test.fragmentation.ju.utils.UnfragmentTest;
import org.polarsys.capella.test.fragmentation.ju.utils.initegrity.IntegrityChecker;
import org.polarsys.capella.test.framework.api.NonDirtyTestCase;
import org.polarsys.capella.test.framework.api.step.AbstractTestStep;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public abstract class FragmentModelTestFramework
extends NonDirtyTestCase {
    protected String _SFRoot = "252f9917-170a-4d65-83f8-a5b651164a95";
    protected String SF1Id = "1e4876cd-8cc0-4a97-a2fd-8d32f0c65848";
    protected String SF2Id = "932cc184-bcf7-497c-a844-3bbb8d902328";
    protected String _LC1Id = "2ebf9a78-92b3-4c19-82cf-94db30e1fee1";
    protected String _LC2Id = "9d407730-701d-4bdb-b0e5-510cd0204642";
    protected String _LC21Id = "4ab87051-68b9-47e8-8045-f41134c4e614";
    protected String UC1FromLogicalSystem_ID = "1e8b6132-a356-45d8-97cd-9a6bdcd5d768";
    protected String LC3_ID = "3114de2b-4a24-4597-ab21-ca974f519013";
    protected String LC3_3_ID = "be72dcc7-6293-4909-8731-ce1c7f73f8a1";
    protected String LC3_1_ID = "66bfe889-7ce9-41c8-9c80-0e59c0309f4b";
    protected String LF2_3_ID = "06bf9abd-6e2c-4403-9330-65ed0d208533";
    protected String OA2_ID = "1baf12d4-c3c4-484a-9c72-f37227eb928a";
    protected String LA_LogicalArchitecture_ID = "0492f15a-1b43-4aa5-97bb-bd75a4eec935";
    protected String PA_PhysicalArchitecture_ID = "4278e180-b80e-49f4-bdd3-61c69f0c5946";
    protected String SA_OA2 = "b913cc1d-abd0-409a-b5c8-77328baf4f15";
    protected String OA2_1ID = "dc08ee20-0272-4a3e-975e-0d85c9c8a65d";
    protected String LFPkg1_ID = "ea8f951d-11c3-4265-ae7e-a18cb13a97bd";
    protected String LC2_CapabilitiesID = "3aa26bfd-ec5b-4afd-9793-765a93bee2b5";
    protected String PA_PhysicalSystemID = "e0b20cc0-2fd6-4e26-bf20-0e6b1a090d01";
    protected String PA_PhysicalFunctionsRPFID = "250d520b-e135-4089-97fc-83d502dd6d44";
    protected String LA_LogicalSystemID = "e6f8a038-0fc9-48b7-9910-2f665c9fad74";
    protected String _currentProjectName;
    protected String LA_LDFB_OA2 = "[LDFB] OA2 - Logical Data Flow Blank";
    protected String LA_LAB = "[LAB] Logical System with Pattern - Logical Architecture Blank";
    protected Map<String, EObject> mapSemanticObjects;
    protected Set<IFile> projectFiles;
    protected Session session;
    protected SessionContext context;
    protected IFile _airdFile;
    protected IFile _m2File;
    protected Map<String, Dimension> _sessionTablesMap = new HashMap<String, Dimension>();
    EStructuralFeature idFeature = ModellingcorePackage.Literals.MODEL_ELEMENT__ID;
    protected Map<String, Integer> _sessionDiagramsMap = new HashMap<String, Integer>();

    public String getCurrentProjectName() {
        return "FragmentTestModel";
    }

    public void setCurrentProjectName(String name) {
        this._currentProjectName = name;
    }

    protected void init() {
        this.session = this.getSession(this.getCurrentProjectName());
        this.context = new SessionContext(this.session);
        DiagramHelper.setPreferenceAutoRefresh((boolean)false);
        DiagramHelper.setPrefereneRefreshOnOpening((boolean)false);
        this.mapSemanticObjects = new HashMap<String, EObject>();
        this._airdFile = FileHelper.getPlatformFile((String)(String.valueOf(this.getCurrentProjectName()) + '/' + FragmentationMessages.airdName));
        this._m2File = FileHelper.getPlatformFile((String)(String.valueOf(this.getCurrentProjectName()) + '/' + FragmentationMessages.m2Name));
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.getCurrentProjectName());
    }

    public void fragmentWithRefChecks(SessionContext context, String id) {
        new FragmentTest(context, this.getEObject(id)).run();
    }

    public void fragment(SessionContext context, String id) {
        new FragmentTest(context, this.getEObject(id)){

            @Override
            protected void postFragmentChecks(EObject objectToFragment, int numberOfProperChildren, Map<EObject, Integer> eObjectRefCount) {
            }
        }.run();
    }

    public void fragmentNonAbusive(SessionContext context, String id) {
        new NonAbusiveFragmentTest(context, this.getEObject(id));
    }

    public void unfragmentWithRefChecks(SessionContext context, String id) {
        new UnfragmentTest(context, this.getEObject(id)).run();
    }

    public void unfragment(SessionContext context, String id) {
        new UnfragmentTest(context, this.getEObject(id)){

            @Override
            protected void postUnfragmentChecks(EObject objectToUnfragment, int numberOfProperChildren, Map<EObject, Integer> eObjectRefCount) {
            }
        }.run();
    }

    protected EObject getEObject(String id) {
        EObject eObject = this.context.getSemanticElement(id);
        if (eObject == null) {
            eObject = this.mapSemanticObjects.get(id);
        }
        FragmentModelTestFramework.assertFalse((eObject == null ? 1 : 0) != 0);
        return eObject;
    }

    public DiagramContext openDiagram(SessionContext context, String diagramName, final Set<IFile> files) {
        return (DiagramContext)new OpenDiagramStep(context, diagramName){

            protected void postRunTest() {
                try {
                    FragmentUtils.setIFileListReadOnly(files);
                }
                catch (CoreException e) {
                    FragmentModelTestFramework.fail((String)e.getMessage());
                }
                super.postRunTest();
            }
        }.run();
    }

    public DiagramContext createDiagram(SessionContext context, String targetId, String diagramName, final Set<IFile> files) {
        return (DiagramContext)new CreateDiagramStep(context, targetId, diagramName){

            protected void postRunTest() {
                try {
                    FragmentUtils.setIFileListReadOnly(files);
                }
                catch (CoreException e) {
                    FragmentModelTestFramework.fail((String)e.getMessage());
                }
                super.postRunTest();
            }
        }.run();
    }

    protected void checkModelIntegrity() {
        new AbstractTestStep(this.context){

            public Object getResult() {
                return null;
            }

            protected void runTest() {
                FragmentModelTestFramework.assertNotNull((String)FragmentationMessages.nullSession, (Object)FragmentModelTestFramework.this.context);
                IntegrityChecker checker = new IntegrityChecker();
                IStatus status = checker.getStatus(FragmentModelTestFramework.this.session, null, (IProgressMonitor)new NullProgressMonitor());
                FragmentModelTestFramework.assertTrue((String)MessageFormat.format(FragmentationMessages.duplicatedModelElements, status.toString()), (boolean)status.isOK());
            }
        }.run();
    }

    protected void checkLoadedFragmentsNumber(final int expectedFragmentsNumber_p) {
        new AbstractTestStep(this.context){

            public Object getResult() {
                return null;
            }

            protected void runTest() {
                FragmentModelTestFramework.assertNotNull((String)FragmentationMessages.nullSession, (Object)FragmentModelTestFramework.this.context);
                Set allSessionResources = FragmentModelTestFramework.this.session.getAllSessionResources();
                int loadedFragmentsNb = allSessionResources.size() - 1;
                FragmentModelTestFramework.assertTrue((String)MessageFormat.format(FragmentationMessages.wrongFragmentsNumber, FragmentModelTestFramework.this.context.toString(), loadedFragmentsNb, expectedFragmentsNumber_p), (loadedFragmentsNb == expectedFragmentsNumber_p ? 1 : 0) != 0);
            }
        }.run();
    }

    protected void checkFragmentTablesDiagramsNumber(final String fragmentName_p, final int expectedNumber_p) {
        new AbstractTestStep(this.context){

            protected void runTest() {
                String airdFragmentPath = String.valueOf(FragmentModelTestFramework.this.getCurrentProjectName()) + "/fragments/" + fragmentName_p;
                IFile airdFragmentFile = FileHelper.getPlatformFile((String)airdFragmentPath);
                FragmentModelTestFramework.assertNotNull((String)MessageFormat.format(FragmentationMessages.errorInGetFile, airdFragmentPath), (Object)airdFragmentFile);
                Session fragmentSession = TestHelper.openOrGetSession((IFile)airdFragmentFile);
                FragmentModelTestFramework.assertNotNull((String)FragmentationMessages.nullSession, (Object)fragmentSession);
                AirdResource fragmentAirdResource = FragmentModelTestFramework.this.getSessionResource(fragmentSession, airdFragmentFile);
                DAnalysis fragmentAnalysis = (DAnalysis)fragmentAirdResource.getContents().get(0);
                int allRepresentationsNumber = 0;
                EList ownedViews = fragmentAnalysis.getOwnedViews();
                for (DView currentView : ownedViews) {
                    int viewRepresentationsNumber = new DViewQuery(currentView).getLoadedRepresentations().size();
                    allRepresentationsNumber += viewRepresentationsNumber;
                }
                FragmentModelTestFramework.assertTrue((String)MessageFormat.format(FragmentationMessages.wrongTablesDiagramsNumber, fragmentName_p, allRepresentationsNumber, expectedNumber_p), (allRepresentationsNumber == expectedNumber_p ? 1 : 0) != 0);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    protected void checkFragmentModelElementsNumber(final String fragmentName_p, final int expectedNumber_p) {
        new AbstractTestStep(this.context){

            protected void runTest() {
                String airdFragmentPath = String.valueOf(FragmentModelTestFramework.this.getCurrentProjectName()) + "/fragments/" + fragmentName_p;
                IFile airdFragmentFile = FileHelper.getPlatformFile((String)airdFragmentPath);
                FragmentModelTestFramework.assertNotNull((String)MessageFormat.format(FragmentationMessages.errorInGetFile, airdFragmentPath), (Object)airdFragmentFile);
                Session fragmentSession = TestHelper.openOrGetSession((IFile)airdFragmentFile);
                FragmentModelTestFramework.assertNotNull((String)FragmentationMessages.nullSession, (Object)fragmentSession);
                EList semanticResources = fragmentSession.getTransactionalEditingDomain().getResourceSet().getResources();
                CapellamodellerResourceImpl m2Resource = null;
                String fragmentURIName = fragmentName_p.replace(" ", "%20");
                fragmentURIName = fragmentURIName.replace("[", "%5B");
                fragmentURIName = fragmentURIName.replace("]", "%5D");
                fragmentURIName = fragmentURIName.replace(".airdfragment", "");
                for (Resource current : semanticResources) {
                    URI uri = current.getURI();
                    if (uri.toString().contains("SYSOA2")) {
                        System.out.println("aaa");
                    }
                    if (!uri.toString().contains(String.valueOf(fragmentURIName) + ".melody")) continue;
                    m2Resource = (CapellamodellerResourceImpl)current;
                    break;
                }
                FragmentModelTestFramework.assertNotNull((String)"The expected CapellaModeller file was not found in the semantic resources.", m2Resource);
                Map eObjectToIDMap = m2Resource.getEObjectToIDMap();
                int elementsNb = eObjectToIDMap.size();
                FragmentModelTestFramework.assertTrue((String)MessageFormat.format(FragmentationMessages.wrongModelElementsNumber, fragmentName_p, elementsNb, expectedNumber_p), (elementsNb == expectedNumber_p ? 1 : 0) != 0);
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    protected void retrieveDiagramElementsNumber() {
        new AbstractTestStep(this.context){

            protected void runTest() {
                Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(FragmentModelTestFramework.this.session);
                for (DRepresentation currentRepresentation : allRepresentations) {
                    if (currentRepresentation instanceof DTable) {
                        DTable currentTable = (DTable)currentRepresentation;
                        Dimension tableSize = new Dimension(currentTable.getColumns().size(), currentTable.getLines().size());
                        String key = String.valueOf(currentTable.getUid()) + ":" + (String)currentTable.getTarget().eGet(FragmentModelTestFramework.this.idFeature);
                        FragmentModelTestFramework.this._sessionTablesMap.put(key, tableSize);
                    }
                    if (!(currentRepresentation instanceof DSemanticDiagram)) continue;
                    DSemanticDiagram currentDiagram = (DSemanticDiagram)currentRepresentation;
                    String key = String.valueOf(currentDiagram.getUid()) + ":" + (String)currentDiagram.getTarget().eGet(FragmentModelTestFramework.this.idFeature);
                    Integer number = currentDiagram.getDiagramElements().size();
                    FragmentModelTestFramework.this._sessionDiagramsMap.put(key, number);
                }
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    protected void openAndCheckAllSessionRepresentations() {
        new AbstractTestStep(this.context){

            protected void runTest() {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                resources.add(FragmentModelTestFramework.this.session.getSessionResource());
                resources.addAll(FragmentModelTestFramework.this.session.getReferencedSessionResources());
                for (Resource currentResource : resources) {
                    ResourceSetSync.ResourceStatus resourceStatus = ResourceSetSync.getStatus((Resource)currentResource);
                    FragmentModelTestFramework.assertTrue((String)MessageFormat.format(FragmentationMessages.resourceStatusNotSync, currentResource.toString(), resourceStatus), (resourceStatus == ResourceSetSync.ResourceStatus.SYNC ? 1 : 0) != 0);
                }
                List allRepresentations = (List)DialectManager.INSTANCE.getAllRepresentations(FragmentModelTestFramework.this.session);
                for (DRepresentation currentRepresentation : allRepresentations) {
                    if (currentRepresentation instanceof DTable) {
                        DTable currentTable = (DTable)currentRepresentation;
                        String key = String.valueOf(currentTable.getUid()) + ":" + (String)currentTable.getTarget().eGet(FragmentModelTestFramework.this.idFeature);
                        Dimension expectedDimension = FragmentModelTestFramework.this._sessionTablesMap.get(key);
                        FragmentModelTestFramework.assertTrue((String)MessageFormat.format(FragmentationMessages.wrongNumberOfColumns, currentRepresentation.toString(), currentTable.getColumns().size(), expectedDimension.width), (currentTable.getColumns().size() == expectedDimension.width ? 1 : 0) != 0);
                        FragmentModelTestFramework.assertTrue((String)MessageFormat.format(FragmentationMessages.wrongNumberOfLines, currentRepresentation.toString(), currentTable.getLines().size(), expectedDimension.height), (currentTable.getLines().size() == expectedDimension.height ? 1 : 0) != 0);
                    }
                    if (!(currentRepresentation instanceof DSemanticDiagram)) continue;
                    DSemanticDiagram currentDiagram = (DSemanticDiagram)currentRepresentation;
                    Integer currentDiagramElementsNumber = currentDiagram.getDiagramElements().size();
                    String key = String.valueOf(currentDiagram.getUid()) + ":" + (String)currentDiagram.getTarget().eGet(FragmentModelTestFramework.this.idFeature);
                    Integer expectedNumber = FragmentModelTestFramework.this._sessionDiagramsMap.get(key);
                    FragmentModelTestFramework.assertTrue((String)MessageFormat.format(FragmentationMessages.wrongNumberOfDiagramElements, currentRepresentation.toString(), currentDiagramElementsNumber, expectedNumber), (boolean)currentDiagramElementsNumber.equals(expectedNumber));
                }
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }

    private AirdResource getSessionResource(Session session_p, IFile file_p) {
        String fileFullPath = file_p.getFullPath().toOSString();
        URI uri = URI.createPlatformResourceURI((String)fileFullPath, (boolean)true);
        for (Resource res : session_p.getAllSessionResources()) {
            if (!res.getURI().equals(uri)) continue;
            return (AirdResource)res;
        }
        FragmentModelTestFramework.fail((String)"There is no resource for the session");
        return null;
    }

    protected void saveAndCloseSession() {
        new AbstractTestStep(this.context){

            public Object getResult() {
                return null;
            }

            protected void runTest() {
                GuiActions.closeSession((Session)FragmentModelTestFramework.this.session, (boolean)true);
            }
        }.run();
    }

    protected void openFragmentSession(final IFile file) {
        new AbstractTestStep(this.context){

            public Object getResult() {
                return null;
            }

            protected void runTest() {
                FragmentModelTestFramework.this.session = TestHelper.openOrGetSession((IFile)file);
                FragmentModelTestFramework.this.session.open((IProgressMonitor)new NullProgressMonitor());
                FragmentModelTestFramework.assertNotNull((Object)FragmentModelTestFramework.this.session);
            }
        }.run();
    }

    public class FragmentCreateContainerTool
    extends CreateContainerTool {
        public FragmentCreateContainerTool(DiagramContext context, String toolName, String containerView) {
            super(context, toolName, containerView);
        }

        protected void initToolArguments() {
            DSemanticDecorator parentContainerView = this.getContainerView();
            this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, (Object)parentContainerView.getTarget());
            this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, (Object)parentContainerView);
        }

        protected DSemanticDecorator getContainerView() {
            return this.getView(this.containerView);
        }

        protected DSemanticDecorator getView(String id) {
            return this.getDiagramContext().getView(FragmentModelTestFramework.this.mapSemanticObjects.get(id));
        }
    }

    public class FragmentCreateDEdgeTool
    extends CreateDEdgeTool {
        public FragmentCreateDEdgeTool(DiagramContext context, String toolName, String idSource, String idTarget) {
            super(context, toolName, idSource, idTarget);
        }

        protected void initToolArguments() {
            DSemanticDecorator edgeSourceView = this.getDiagramContext().getView(this._sourceView);
            if (edgeSourceView == null) {
                edgeSourceView = this.getView(this._sourceView);
            }
            this._toolWrapper.setArgumentValue(ArgumentType.SOURCE, (Object)edgeSourceView);
            DSemanticDecorator edgeTargetView = this.getDiagramContext().getView(this._targetView);
            if (edgeTargetView == null) {
                edgeTargetView = this.getView(this._targetView);
            }
            this._toolWrapper.setArgumentValue(ArgumentType.TARGET, (Object)edgeTargetView);
        }

        protected DSemanticDecorator getView(String id) {
            return this.getDiagramContext().getView(FragmentModelTestFramework.this.mapSemanticObjects.get(id));
        }
    }
}

