/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.massactions.ju.testcases.view.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowDataProvider;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.polarsys.capella.test.massactions.ju.helpers.LayerHelper;
import org.polarsys.capella.test.massactions.ju.helpers.ViewHelper;
import org.polarsys.capella.test.massactions.ju.model.AbstractCapellaMATestCase;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.column.IMAColumnHeaderLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.grid.IMAGridLayer;
import org.polarsys.kitalpha.massactions.edit.MEView;
import org.polarsys.kitalpha.massactions.shared.view.MAView;
import org.polarsys.kitalpha.massactions.visualize.MVView;

public class ColumnFilterTest
extends AbstractCapellaMATestCase {
    @Override
    public void performTest() throws Exception {
        MEView editionView = ViewHelper.getActiveMEView();
        MVView visualizationView = ViewHelper.getActiveMVView();
        this.testColumnFilter((MAView)editionView);
        this.testColumnFilter((MAView)visualizationView);
    }

    public void testColumnFilter(MAView view) {
        int columnIndex;
        ArrayList<EObject> data = new ArrayList<EObject>();
        data.add(this.getObject("3688cf59-97ee-4446-8041-7941cee6c767"));
        view.dataChanged(data);
        List<String> columnNamesToHide = Arrays.asList("name", "visibleInDoc", "ordered", "unique");
        IMAGridLayer gridLayer = LayerHelper.extractGridLayer(view);
        IMABodyLayer bodyLayer = gridLayer.getBodyLayer();
        IMAColumnHeaderLayer columnHeaderLayer = gridLayer.getColumnHeaderLayer();
        IMAColumnPropertyAccessor columnPropertyAccessor = bodyLayer.getColumnPropertyAccessor();
        FilterRowHeaderComposite filterHeaderLayer = columnHeaderLayer.getFilterHeaderLayer();
        FilterRowDataProvider filterRowDataProvider = filterHeaderLayer.getFilterRowDataLayer().getFilterRowDataProvider();
        Map beforeFilteredIndexToObject = Collections.emptyMap();
        Map afterFilteredIndexToObject = Collections.emptyMap();
        for (String columnName : columnNamesToHide) {
            columnIndex = columnPropertyAccessor.getColumnIndex(columnName);
            if (columnIndex == -1) continue;
            ColumnFilterTest.assertFalse((boolean)beforeFilteredIndexToObject.containsKey(columnIndex));
            beforeFilteredIndexToObject = new HashMap(filterRowDataProvider.getFilterIndexToObjectMap());
            filterRowDataProvider.setDataValue(columnIndex, 1, (Object)columnName);
            afterFilteredIndexToObject = new HashMap(filterRowDataProvider.getFilterIndexToObjectMap());
            ColumnFilterTest.assertTrue((boolean)afterFilteredIndexToObject.containsKey(columnIndex));
            ColumnFilterTest.assertEquals((Object)columnName, afterFilteredIndexToObject.get(columnIndex));
        }
        beforeFilteredIndexToObject = new HashMap(filterRowDataProvider.getFilterIndexToObjectMap());
        data.add(this.getObject("3398fdbf-3415-4d03-a457-477324d2e091"));
        view.dataChanged(data);
        afterFilteredIndexToObject = new HashMap(filterRowDataProvider.getFilterIndexToObjectMap());
        ColumnFilterTest.assertEquals(beforeFilteredIndexToObject, afterFilteredIndexToObject);
        data.add(this.getObject("6ff020fc-4b56-45d1-8154-c24fe116bae1"));
        view.dataChanged(data);
        afterFilteredIndexToObject = new HashMap(filterRowDataProvider.getFilterIndexToObjectMap());
        for (String columnName : columnNamesToHide) {
            columnIndex = columnPropertyAccessor.getColumnIndex(columnName);
            if (columnIndex == -1) continue;
            ColumnFilterTest.assertTrue((boolean)afterFilteredIndexToObject.containsKey(columnIndex));
            ColumnFilterTest.assertEquals((Object)columnName, afterFilteredIndexToObject.get(columnIndex));
        }
        ViewHelper.resetViews(view);
    }
}

