/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.migration.ju.testcases.basic;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.polarsys.capella.core.data.migration.handlers.ProjectMigrationHandler;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class MigrationEnabledTest
extends BasicTestCase {
    public void test() throws Exception {
        IProject notACapellaProject = ResourcesPlugin.getWorkspace().getRoot().getProject("notACapellaProject");
        notACapellaProject.create(null);
        notACapellaProject.open(null);
        IProject projectClosed = this.createCapellaProject("projectClosed");
        projectClosed.close(null);
        IProject validProject = this.createCapellaProject("validProject");
        IProject anotherValidProject = this.createCapellaProject("anotherValidProject");
        IProject projectWithoutAfm = this.createCapellaProject("projectWithoutAfm");
        this.deleteFile(projectWithoutAfm, "afm");
        IProject projectWithoutAird = this.createCapellaProject("projectWithoutAird");
        projectWithoutAird.close(null);
        projectWithoutAird.open(null);
        this.deleteFile(projectWithoutAird, "aird");
        IProject projectWithoutCapellaModel = this.createCapellaProject("projectWithoutCapellaModel");
        this.deleteFile(projectWithoutCapellaModel, "melodymodeller");
        MigrationEnabledTest.assertFalse((String)"Migration must be disabled if the selection is not a Capella project", (boolean)this.canMigrate(notACapellaProject));
        MigrationEnabledTest.assertFalse((String)"Migration must be disabled if the selection is a closed project", (boolean)this.canMigrate(projectClosed));
        MigrationEnabledTest.assertFalse((String)"Migration must be disabled if the selection is a project without a capella model", (boolean)this.canMigrate(projectClosed));
        MigrationEnabledTest.assertTrue((String)"Migration must be enabled for this valid project", (boolean)this.canMigrate(validProject));
        MigrationEnabledTest.assertFalse((String)"Migration must be disabled if one element of the selection is not a Capella project", (boolean)this.canMigrate(notACapellaProject, validProject));
        MigrationEnabledTest.assertFalse((String)"Migration must be disabled if one element of the selection is a closed project", (boolean)this.canMigrate(projectClosed, validProject));
        MigrationEnabledTest.assertFalse((String)"Migration must be disabled if one element of the selection is a project without a capella model", (boolean)this.canMigrate(projectClosed, validProject));
        MigrationEnabledTest.assertTrue((String)"Migration must be enabled for this multiple selection of valid projects", (boolean)this.canMigrate(validProject, anotherValidProject));
        MigrationEnabledTest.assertTrue((String)"Migration must be enabled for this project without an afm", (boolean)this.canMigrate(projectWithoutAfm));
        MigrationEnabledTest.assertTrue((String)"Migration must be enabled for this project without an aird", (boolean)this.canMigrate(projectWithoutAird));
        MigrationEnabledTest.assertFalse((String)"Migration must be disable for this project without a capella model", (boolean)this.canMigrate(projectWithoutCapellaModel));
    }

    private IProject createCapellaProject(String name) {
        return GuiActions.newProject((String)name, (boolean)false);
    }

    private void deleteFile(IProject project, String extension) throws CoreException {
        project.getFile(String.valueOf(project.getName()) + "." + extension).delete(true, null);
    }

    private boolean canMigrate(IProject ... projectSelection) {
        return new ProjectMigrationHandler().isValidSelection(Arrays.asList(projectSelection));
    }
}

