/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.patterns;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractIdentifiedElement;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRepository;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.PatternCatalogsPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.test.model.ju.model.MiscModel;
import org.polarsys.capella.test.model.ju.patterns.Messages;

public class ExistingPatternTest
extends MiscModel {
    protected String projectName;
    protected String patternFileName;
    protected List<String> patternCatalog = new ArrayList<String>();

    public ExistingPatternTest(String project_p, String fileName_p, List<String> catalog_p) {
        this.projectName = project_p;
        this.patternFileName = fileName_p;
        this.patternCatalog = catalog_p;
    }

    public void test() throws Exception {
        final ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
        Session session = this.getSession(this.getRequiredTestModels().get(0));
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                try {
                    String URLpatternFile = "platform:/resource/" + ExistingPatternTest.this.projectName + "/" + ExistingPatternTest.this.patternFileName + "." + "patterns";
                    URL fileURL = new URL(URLpatternFile);
                    java.net.URI uri = fileURL.toURI();
                    URI fileURI = URI.createURI((String)uri.toString());
                    PatternCatalogsPlugin patternPlugin = new PatternCatalogsPlugin();
                    ResourceSet resourceSet = manager.getEditingDomain().getResourceSet();
                    PatternRepository openCatalog = patternPlugin.getAccessor().openCatalog(fileURI, resourceSet);
                    ExistingPatternTest.assertNotNull((String)MessageFormat.format(Messages.wrongPatternFile, ExistingPatternTest.this.patternFileName), (Object)openCatalog);
                    EList patterns = openCatalog.getPatterns();
                    List allPatternIds = patterns.stream().map(AbstractIdentifiedElement::getId).collect(Collectors.toList());
                    for (String patternIdToTest : ExistingPatternTest.this.patternCatalog) {
                        boolean containedInCatalog = false;
                        if (allPatternIds.contains(patternIdToTest)) {
                            containedInCatalog = true;
                        }
                        ExistingPatternTest.assertTrue((String)MessageFormat.format(Messages.notFoundPatternInCatalog, patternIdToTest, ExistingPatternTest.this.patternFileName), (boolean)containedInCatalog);
                    }
                }
                catch (Exception exception) {
                    ExistingPatternTest.fail((String)exception.getMessage());
                }
            }
        };
        manager.execute((ICommand)cmd);
        ExecutionManagerRegistry.getInstance().removeManager(manager);
    }
}

