/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.propertyviews;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistry;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyRegistryFactory;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.mdsofa.common.helper.EcoreHelper;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class PropertyViewsTest
extends BasicTestCase {
    protected List<EClass> excludedClasses;
    protected List<EClass> concreteClasses;

    public void test() throws Exception {
        this.excludedClasses = Arrays.asList(InteractionPackage.Literals.SEQUENCE_MESSAGE_VALUATION);
        this.init();
        this.testPropertyViewsForAll();
        this.clear();
    }

    public void testPropertyViewsForAll() throws Exception {
        int globalCount = this.concreteClasses.size();
        System.out.println("Concrete classes: " + globalCount);
        int customCount = this.countCustomPropertyViews(this.concreteClasses, "org.polarsys.capella.core.data.capellamodeller.properties");
        System.out.println("[Capella Navigator] Custom property views: " + customCount);
        System.out.println("[Capella Navigator] Generated property views: " + (globalCount - customCount));
    }

    public int countCustomPropertyViews(List<EClass> cls_p, String contributorId_p) {
        int counter = 0;
        IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("capella.project.explorer");
        TabbedPropertyRegistry registry = TabbedPropertyRegistryFactory.getInstance().createRegistry(new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "org.polarsys.capella.core.data.capellamodeller.properties";
            }
        });
        ArrayList<String> errors = new ArrayList<String>();
        for (EClass eclass : cls_p) {
            EObject object = eclass.getEPackage().getEFactoryInstance().create(eclass);
            ITabDescriptor[] result = registry.getTabDescriptors((IWorkbenchPart)part, (ISelection)new StructuredSelection((Object)object));
            Optional<ITabDescriptor> capella = Arrays.asList(result).stream().filter(x -> "BaseCapella".equals(x.getId())).findFirst();
            if (!capella.isPresent()) {
                errors.add(NLS.bind((String)"No Property Tab 'Capella' for {0}", (Object)(String.valueOf(eclass.getName()) + eclass.getEPackage().getNsPrefix())));
                continue;
            }
            ITabDescriptor tab = capella.get();
            if (tab.getSectionDescriptors().isEmpty()) {
                errors.add(NLS.bind((String)"Property Tab 'Capella' is empty for {0}", (Object)(String.valueOf(eclass.getName()) + eclass.getEPackage().getNsPrefix())));
            }
            for (Object section : tab.getSectionDescriptors()) {
                ISectionDescriptor descriptor = (ISectionDescriptor)section;
                if (descriptor.getSectionClass() != null) continue;
                errors.add(NLS.bind((String)"Property Capella Section no longer exist {0}", (Object)descriptor.getSectionClass()));
            }
        }
        PropertyViewsTest.assertTrue((String)errors.stream().collect(Collectors.joining("\n")), (boolean)errors.isEmpty());
        return counter;
    }

    private void init() {
        this.concreteClasses = new ArrayList<EClass>(0);
        ResourceSet resourceSet = TestHelper.getEditingDomain().getResourceSet();
        TreeIterator contents = resourceSet.getAllContents();
        while (contents.hasNext()) {
            EClass classType;
            Notifier type = (Notifier)contents.next();
            if (!(type instanceof EClass) || (classType = EcoreHelper.getStaticClass((EClass)((EClass)type))).isAbstract()) continue;
            this.concreteClasses.add(classType);
        }
        this.concreteClasses.removeAll(this.excludedClasses);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
        ResourceSet resourceSet = manager.getEditingDomain().getResourceSet();
        resourceSet.getResource(FileHelper.getFileFullUri((String)"/org.polarsys.capella.core.data.gen/model/CapellaModeller.ecore"), true);
        int resourcesCount = resourceSet.getResources().size();
        int previousResourcesCount = 0;
        while (resourcesCount != previousResourcesCount) {
            previousResourcesCount = resourcesCount;
            ArrayList resources = new ArrayList(resourceSet.getResources());
            for (Resource resource : resources) {
                EcoreUtil.resolveAll((Resource)resource);
            }
            resourcesCount = resourceSet.getResources().size();
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void clear() {
        this.concreteClasses.clear();
        this.concreteClasses = null;
    }
}

