/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.rename;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.model.ju.model.RenameModel;

public class RenameModelTestCase
extends RenameModel {
    public void test() {
        String oldFileRootName = this.getRequiredTestModels().get(0);
        String oldFileName = String.valueOf(this.getRequiredTestModels().get(0)) + "." + "melodymodeller";
        IFile file = this.getCapellaFileForLoadedModel(oldFileRootName);
        if (file.exists()) {
            String newModelName = "renamed_" + oldFileName;
            GuiActions.renameModelFile((IFile)file, (String)newModelName);
            Session session = this.getSessionForTestModel(oldFileRootName);
            RenameModelTestCase.assertTrue((String)"Session is not loaded with renamed resource", (session != null ? 1 : 0) != 0);
            session.close((IProgressMonitor)new NullProgressMonitor());
            IFile airdFile = this.getAirdFileForLoadedModel(oldFileRootName);
            String airdContent = "";
            try {
                airdContent = FileHelper.readFile((String)airdFile.getFullPath().toString());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            RenameModelTestCase.assertTrue((String)"AIRD content is not updated after model rename.", (boolean)airdContent.contains(newModelName));
            IFile fileRenamed = IResourceHelpers.getEclipseProjectInWorkspace((String)oldFileRootName).getFile(newModelName);
            GuiActions.renameModelFile((IFile)fileRenamed, (String)oldFileName);
        }
    }
}

