/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.rename;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.commands.ICommandService;
import org.polarsys.capella.test.framework.api.BasicTestArtefact;
import org.polarsys.capella.test.framework.api.ModelProviderHelper;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.test.model.ju.model.RenameModel;

public class RenameProjectWithOpenedSessionTestCase
extends RenameModel {
    private static final String LTK_RENAME_ID = "org.eclipse.ltk.ui.refactoring.commands.renameResource";
    private boolean isRenamedProject = false;
    private String newProjectName;

    public void test() throws Exception {
        String oldProjectName = this.getRequiredTestModels().get(0);
        IFile file = this.getCapellaFileForLoadedModel(oldProjectName);
        if (file.exists()) {
            this.newProjectName = "renamed_" + oldProjectName;
            Session sessionBeforeRename = this.getSessionForTestModel(oldProjectName);
            RenameProjectWithOpenedSessionTestCase.assertTrue((String)"Session is not loaded for old project", (sessionBeforeRename != null ? 1 : 0) != 0);
            IProject oldProject = file.getProject();
            RenameCommandStateToggle cmdStateToggle = new RenameCommandStateToggle();
            cmdStateToggle.undefine();
            try {
                this.renameResource((IResource)oldProject);
            }
            catch (Exception e) {
                RenameProjectWithOpenedSessionTestCase.assertTrue((String)("Exception while renaming the project\n" + e.getMessage()), (boolean)false);
            }
            this.isRenamedProject = true;
            cmdStateToggle.define();
            IProject renamedProject = IResourceHelpers.getEclipseProjectInWorkspace((String)this.newProjectName);
            RenameProjectWithOpenedSessionTestCase.assertNotNull((Object)renamedProject);
            RenameProjectWithOpenedSessionTestCase.assertTrue((String)"Renamed project does not exist", (boolean)renamedProject.exists());
            RenameProjectWithOpenedSessionTestCase.assertTrue((sessionBeforeRename.getAllSessionResources().size() == 0 ? 1 : 0) != 0);
            RenameProjectWithOpenedSessionTestCase.assertTrue((sessionBeforeRename.getSemanticResources().size() == 0 ? 1 : 0) != 0);
        }
    }

    private void renameResource(IResource resource) {
        RenameResourceAction renameResourceAction = new RenameResourceAction(this.getShellProvider()){

            protected String queryNewResourceName(IResource resource) {
                return RenameProjectWithOpenedSessionTestCase.this.newProjectName;
            }
        };
        renameResourceAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)resource));
        renameResourceAction.run();
    }

    @Override
    public List<String> getRequiredTestModels() {
        if (this.isRenamedProject) {
            return Arrays.asList(this.newProjectName);
        }
        return super.getRequiredTestModels();
    }

    protected void tearDown() throws Exception {
        List<String> projectNamesToLoad = this.getRequiredTestModels();
        if (projectNamesToLoad != null) {
            for (String modelName : projectNamesToLoad) {
                if (modelName.equals(this.newProjectName)) continue;
                ModelProviderHelper.getInstance().getModelProvider().releaseTestModel(modelName, (BasicTestArtefact)this);
            }
        }
    }

    private IShellProvider getShellProvider() {
        return new IShellProvider(){

            public Shell getShell() {
                return null;
            }
        };
    }

    private class RenameCommandStateToggle {
        private String name;
        private Category category;
        private IParameter[] parameters;
        private ParameterType returnType;
        private String description;
        private boolean undefined = false;

        private RenameCommandStateToggle() {
        }

        protected void define() {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command cmd = commandService.getCommand(RenameProjectWithOpenedSessionTestCase.LTK_RENAME_ID);
            if (cmd != null && this.undefined && !cmd.isDefined()) {
                this.undefined = false;
                cmd.define(this.name, this.description, this.category, this.parameters, this.returnType);
            }
        }

        protected void undefine() {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command cmd = commandService.getCommand(RenameProjectWithOpenedSessionTestCase.LTK_RENAME_ID);
            if (cmd != null && !this.undefined && cmd.isDefined()) {
                this.undefined = true;
                try {
                    this.name = cmd.getName();
                    this.category = cmd.getCategory();
                    this.parameters = cmd.getParameters();
                    this.returnType = cmd.getReturnType();
                    this.description = cmd.getDescription();
                    cmd.undefine();
                }
                catch (NotDefinedException notDefinedException) {
                    // empty catch block
                }
            }
        }
    }
}

