/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.testcases.datalisteners;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.session.Session;
import org.junit.Assert;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeMechanismExt;
import org.polarsys.capella.core.data.information.ElementKind;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;
import org.polarsys.capella.test.framework.model.GenericModel;
import org.polarsys.capella.test.model.ju.model.MiscModel;

public class ExchangeItemsCommunicationLinks
extends MiscModel {
    public static final String RANDOM_NAME_1 = "AAA";
    public static final String RANDOM_NAME_2 = "BBB";
    public static final String RANDOM_NAME_3 = "CCC";

    public void test() {
        Session session = this.getSession(this.getRequiredTestModels().get(0));
        SessionContext context = new SessionContext(session);
        SkeletonHelper.createActor((String)"0b6d6f19-fae4-4a23-aee3-8ac84d7a1e64", (String)GenericModel.ACTOR_1, (String)GenericModel.PART_1, (SessionContext)context);
        SkeletonHelper.createActor((String)"0b6d6f19-fae4-4a23-aee3-8ac84d7a1e64", (String)GenericModel.ACTOR_2, (String)GenericModel.PART_2, (SessionContext)context);
        SkeletonHelper.createInterface((String)"b8b67e89-956c-405f-88a0-1099e666a13b", (String)GenericModel.INTERFACE_1, (SessionContext)context);
        SkeletonHelper.createExchangeItem((String)"b8b67e89-956c-405f-88a0-1099e666a13b", (String)GenericModel.EXCHANGE_ITEM_1, (SessionContext)context);
        SkeletonHelper.createExchangeItemAllocation((String)GenericModel.OBJECT_1, (String)GenericModel.INTERFACE_1, (String)GenericModel.EXCHANGE_ITEM_1, (SessionContext)context);
        SkeletonHelper.createExchangeItemElement((String)GenericModel.EXCHANGE_ITEM_1, (String)GenericModel.EXCHANGE_ITEM_ELEMENT_1, (SessionContext)context);
        SkeletonHelper.createCommunicationLinkSend((String)GenericModel.CL_1, (String)GenericModel.ACTOR_1, (String)GenericModel.EXCHANGE_ITEM_1, (SessionContext)context);
        SkeletonHelper.createCommunicationLinkReceive((String)GenericModel.CL_2, (String)GenericModel.ACTOR_2, (String)GenericModel.EXCHANGE_ITEM_1, (SessionContext)context);
        this.setMechanism(GenericModel.EXCHANGE_ITEM_1, ExchangeMechanism.EVENT, context);
        this.ensureSynchronizedElements(context, ElementKind.TYPE);
        this.setMechanism(GenericModel.EXCHANGE_ITEM_1, ExchangeMechanism.SHARED_DATA, context);
        this.ensureSynchronizedElements(context, ElementKind.TYPE);
        this.setMechanism(GenericModel.EXCHANGE_ITEM_1, ExchangeMechanism.OPERATION, context);
        this.ensureSynchronizedElements(context, ElementKind.MEMBER);
        this.setMechanism(GenericModel.EXCHANGE_ITEM_1, ExchangeMechanism.FLOW, context);
        this.ensureSynchronizedElements(context, ElementKind.TYPE);
    }

    private void ensureSynchronizedElements(SessionContext context, ElementKind kind) {
        SkeletonHelper.createExchangeItemElement((String)GenericModel.EXCHANGE_ITEM_1, (String)GenericModel.EXCHANGE_ITEM_ELEMENT_2, (SessionContext)context);
        this.ensureElement(context, GenericModel.EXCHANGE_ITEM_ELEMENT_1, kind);
        this.ensureElement(context, GenericModel.EXCHANGE_ITEM_ELEMENT_2, kind);
        this.ensureLink(context, GenericModel.CL_1, GenericModel.EXCHANGE_ITEM_1, true);
        this.ensureLink(context, GenericModel.CL_2, GenericModel.EXCHANGE_ITEM_1, false);
        this.ensureAllocation(context, GenericModel.OBJECT_1, GenericModel.EXCHANGE_ITEM_1);
    }

    private void ensureAllocation(SessionContext context, String linkId, String itemId) {
        ExchangeItemAllocation link = (ExchangeItemAllocation)context.getSemanticElement(linkId);
        ExchangeItem item = (ExchangeItem)context.getSemanticElement(itemId);
        Assert.assertEquals((Object)link.getSendProtocol(), (Object)ExchangeMechanismExt.getProtocol((ExchangeMechanism)item.getExchangeMechanism(), (boolean)true));
        Assert.assertEquals((Object)link.getReceiveProtocol(), (Object)ExchangeMechanismExt.getProtocol((ExchangeMechanism)item.getExchangeMechanism(), (boolean)false));
    }

    private void ensureLink(SessionContext context, String linkId, String itemId, boolean isSender) {
        CommunicationLink link = (CommunicationLink)context.getSemanticElement(linkId);
        ExchangeItem item = (ExchangeItem)context.getSemanticElement(itemId);
        Assert.assertEquals((Object)link.getProtocol(), (Object)ExchangeMechanismExt.getProtocol((ExchangeMechanism)item.getExchangeMechanism(), (boolean)isSender));
        Assert.assertEquals((Object)link.getKind(), (Object)ExchangeMechanismExt.getKind((ExchangeMechanism)item.getExchangeMechanism(), (boolean)isSender));
    }

    private void ensureElement(SessionContext context, String elementId, ElementKind member) {
        ExchangeItemElement element = (ExchangeItemElement)context.getSemanticElement(elementId);
        Assert.assertTrue((boolean)member.equals((Object)element.getKind()));
    }

    private void setMechanism(String exchangeItemId, ExchangeMechanism mechanism, SessionContext context) {
        SkeletonHelper.setAttribute((EObject)context.getSemanticElement(exchangeItemId), (Object)mechanism, (EStructuralFeature)InformationPackage.Literals.EXCHANGE_ITEM__EXCHANGE_MECHANISM, (SessionContext)context);
    }
}

