/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.model.ju.testcases.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaDeleteAction;
import org.polarsys.capella.core.preferences.Activator;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.model.ju.model.MiscModel;

public class DeleteProtectedElements
extends MiscModel {
    protected ScopedPreferenceStore preferenceStore;
    protected List<String> protectedElementsIds;
    protected SessionContext context;
    protected static final String SHOULD_BE_DELETED = "The element {0} {1} should be able to be deleted, but is not";
    protected static final String SHOULD_NOT_BE_DELETED = "The element {0} {1} should NOT be able to be deleted, but is is";

    protected void setUp() throws Exception {
        super.setUp();
        Session session = this.getSession(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.preferenceStore = (ScopedPreferenceStore)Activator.getDefault().getPreferenceStore();
        this.protectedElementsIds = new ArrayList<String>();
        this.protectedElementsIds.addAll(this.getProjects());
        this.protectedElementsIds.addAll(this.getSystemEngineering());
        this.protectedElementsIds.addAll(this.getBlockArchitectures());
        this.protectedElementsIds.addAll(this.getRootComponents());
        this.protectedElementsIds.addAll(this.getRootParts());
        this.protectedElementsIds.addAll(this.getRootFunctions());
    }

    public void test() {
        boolean canDelete;
        NamedElement element;
        ArrayList<String> errors = new ArrayList<String>();
        this.enableTheDeletionOfProtectedElements();
        for (String id : this.protectedElementsIds) {
            element = (NamedElement)this.context.getSemanticElement(id);
            canDelete = CapellaDeleteAction.canDelete(Arrays.asList(element));
            if (canDelete) continue;
            errors.add(NLS.bind((String)SHOULD_BE_DELETED, (Object)element.getName(), (Object)element.getId()));
        }
        this.disableTheDeletionOfProtectedElements();
        for (String id : this.protectedElementsIds) {
            element = (NamedElement)this.context.getSemanticElement(id);
            canDelete = CapellaDeleteAction.canDelete(Arrays.asList(element));
            if (!canDelete) continue;
            errors.add(NLS.bind((String)SHOULD_NOT_BE_DELETED, (Object)element.getName(), (Object)element.getId()));
        }
        DeleteProtectedElements.assertTrue((String)errors.stream().collect(Collectors.joining("\n")), (boolean)errors.isEmpty());
    }

    private void disableTheDeletionOfProtectedElements() {
        this.preferenceStore.putValue("Delete_Protected_Elements", String.valueOf(true));
    }

    private void enableTheDeletionOfProtectedElements() {
        this.preferenceStore.putValue("Delete_Protected_Elements", String.valueOf(false));
    }

    protected List<String> getProjects() {
        return Arrays.asList("794e6786-9355-4ae4-87a6-2734ede475dd");
    }

    protected List<String> getSystemEngineering() {
        return Arrays.asList("b3f7e50c-ce73-45c0-ac2a-38365b7d0e91");
    }

    protected List<String> getBlockArchitectures() {
        return Arrays.asList("c7daf8d7-abf1-4ba8-bbc5-6acc83d55cfe", "cfc9925e-c0f5-4b59-9abf-53e6a50cfc93", "6423fb82-eda3-42be-a0ad-bb121fee03ce", "93e72add-98f8-4f01-81d1-66b443275e2c", "e4e1c7e9-9174-4c56-8375-65cecab211a1");
    }

    protected List<String> getRootComponents() {
        return Arrays.asList("4630572f-7502-4263-a994-89ced76f21a8", "030e91dc-441e-4107-b0ea-0b08acaccf13", "6649e0be-1e19-433c-93df-47a8f8918750", "3f8ed798-46cd-4dd6-8469-568ecefad211");
    }

    protected List<String> getRootParts() {
        return Arrays.asList("b6cba2a7-2061-4900-975d-1fb8e64cdba6", "7d43c14e-5d52-4902-a1a7-6e6cfe451ac3", "bf3c1440-1e14-497b-8327-13634e41af70", "e2b66a7a-c705-4450-95f3-b440d01701c0");
    }

    protected List<String> getRootFunctions() {
        return Arrays.asList("bdb29a96-066a-4feb-97df-8949a15a69e0", "c5bc9e6f-5878-4ce3-85ef-61d44ac0175c", "835edbff-fad4-4cfa-8574-82663347ad7d", "82809bc0-4858-4da3-a239-7b7fb8532e6b");
    }
}

