/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.identifier;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.PopupMenu;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.platform.sirius.ui.services.IElementIdentifierService;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.odesign.identifier.IdentifierHelper;

public class ToolIdentifierConsistencyTest
extends BasicTestCase {
    public void test() {
        ArrayList errors = new ArrayList();
        IElementIdentifierService elementIdentifier = (IElementIdentifierService)PlatformUI.getWorkbench().getService(IElementIdentifierService.class);
        for (Viewpoint viewpoint : ViewpointSelection.getViewpoints((String)"melodymodeller")) {
            EList descriptions = viewpoint.getOwnedRepresentations();
            for (RepresentationDescription description : descriptions) {
                if (!(description instanceof DiagramDescription)) continue;
                DiagramDescription diagramDescription = (DiagramDescription)description;
                IdentifierHelper.getTools(diagramDescription).forEach(element -> {
                    String toolIdentifier = elementIdentifier.getIdentifier(diagramDescription, element);
                    if (element instanceof PopupMenu && !toolIdentifier.endsWith(".menu")) {
                        errors.add(NLS.bind((String)"Menu {0} doens't ends with '.menu'.", (Object)element.getName()));
                    } else if (element instanceof CompositeFilterDescription && !toolIdentifier.endsWith(".filter") && !"ModelExtensionFilter".equals(element.getName())) {
                        errors.add(NLS.bind((String)"Filter {0} doens't ends with '.filter'.", (Object)element.getName()));
                    }
                });
            }
        }
        if (!errors.isEmpty()) {
            ToolIdentifierConsistencyTest.assertTrue((String)errors.stream().collect(Collectors.joining("\n")), (boolean)errors.isEmpty());
        }
    }
}

