/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.odesign.ju.titleblock;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.odesign.helper.OdesignTestHelper;
import org.polarsys.capella.test.odesign.ju.titleblock.CheckTitleBlockTest;

public class CheckTitleBlockFilterTest
extends CheckTitleBlockTest {
    public void test() throws Exception {
        AbstractNodeMapping titleBlockContainerMapping;
        DiagramDescription classDiagramDescription;
        Viewpoint commonVP = OdesignTestHelper.getViewpointByName("Common");
        if (commonVP == null) {
            CheckTitleBlockFilterTest.fail((String)"Common viewpoint not found");
        }
        if ((classDiagramDescription = OdesignTestHelper.getDiagramDescriptionByName(commonVP, "Class Diagram Blank")) == null) {
            CheckTitleBlockFilterTest.fail((String)"CBD diagram description not found");
        }
        if ((titleBlockContainerMapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(classDiagramDescription, "DT_TitleBlockContainer")) == null) {
            CheckTitleBlockFilterTest.fail((String)"Title block container mapping not found");
        }
        this.assertAllDiagramContainFilterOnMapping("hide.diagram.title.blocks.filter", (DiagramElementMapping)titleBlockContainerMapping);
        this.assertAllDiagramContainFilterOnMapping("hide.element.title.blocks.filter", (DiagramElementMapping)titleBlockContainerMapping);
    }

    private void assertAllDiagramContainFilterOnMapping(String filterName, DiagramElementMapping mapping) {
        List<DiagramDescription> diagramDescriptionsWithoutFilterOnMapping = this.getDiagramDescriptionsWithoutFilterOnMapping(filterName, mapping);
        CheckTitleBlockFilterTest.assertTrue((String)("The following diagrams do not have Title block " + filterName + " filter: " + diagramDescriptionsWithoutFilterOnMapping.stream().map(m -> m.getName()).collect(Collectors.joining(", "))), (boolean)diagramDescriptionsWithoutFilterOnMapping.isEmpty());
    }

    private List<DiagramDescription> getDiagramDescriptionsWithoutFilterOnMapping(String filterName, DiagramElementMapping mapping) {
        return ViewpointRegistry.getInstance().getViewpoints().stream().flatMap(vp -> vp.getOwnedRepresentations().stream()).filter(DiagramDescription.class::isInstance).map(DiagramDescription.class::cast).filter(des -> !this.isDiagramDescriptionIgnored((DiagramDescription)des)).filter(des -> !OdesignTestHelper.hasFilterOnMapping(des, filterName, mapping)).collect(Collectors.toList());
    }
}

