/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.table.ju.function;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.description.DescriptionPackage;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.table.ju.utils.AbstractTableToolStep;
import org.polarsys.capella.test.table.ju.utils.CreateCellFromIntersectionCommand;
import org.polarsys.capella.test.table.ju.utils.TableTestFramework;
import org.polarsys.capella.test.table.ju.utils.TableTestingHelper;

public abstract class FunctionTableTestFramework
extends TableTestFramework {
    protected String modelName = "SF-OA";
    protected Session session;
    protected SessionContext context;
    protected String diagramID = "e348c8d5-b00e-4147-a4a8-e1450fef6a4d";
    protected OperationalActivity _oa1;
    protected OperationalActivity _oa11;
    protected OperationalActivity _oa2;
    protected OperationalActivity _oa21;
    protected OperationalActivity _oa3;
    protected SystemFunction _sf1;
    protected SystemFunction _sf11;
    protected SystemFunction _sf2;
    protected SystemFunction _sf21;
    protected SystemFunction _sf3;
    protected String tableName = "New System Functions - Operational Activities";
    protected String rootOAId = "4c119ea2-911e-41b6-80a4-72229d0605d7";
    protected String oa1Id = "e5bd33f1-2b66-40ce-b583-2843b27cf608";
    protected String oa11Id = "620be8c3-542d-4b71-b914-d42168312361";
    protected String oa2Id = "b96f55f2-41a5-4922-b5a8-e52525fbb80d";
    protected String oa21Id = "db01f744-be96-4e4c-89a2-2f3f2025bbb2";
    protected String oa3Id = "84000579-6b35-4650-a851-cc9d51cfd0af";
    protected String rootSFId = "06d45db4-d7cd-4d94-9d90-6115e88523f5";
    protected String sf1Id = "69f5c20e-5568-496a-ab5d-52e1bed91b49";
    protected String sf11Id = "3f6d7a1b-3219-4677-8483-1596d74b1490";
    protected String sf2Id = "5bc4bdb3-4002-4d58-9886-4d32911264b3";
    protected String sf21Id = "293d6037-08df-4b5c-aeda-e3cba1a5ee58";
    protected String sf3Id = "75bdd58b-c89b-4fc1-9bb1-dd45ac6dfa11";
    protected String realizationNullErrMsg = "OA Realization on '{0}' is null";
    protected String realizedOAErrMsg = "Realized OA of SF '{0}' is not '{1}'";

    protected void init() {
        this.session = this.getSession(this.modelName);
        this.context = new SessionContext(this.session);
        this._oa1 = (OperationalActivity)this.context.getSemanticElement(this.oa1Id);
        this._oa11 = (OperationalActivity)this.context.getSemanticElement(this.oa11Id);
        this._oa2 = (OperationalActivity)this.context.getSemanticElement(this.oa2Id);
        this._oa21 = (OperationalActivity)this.context.getSemanticElement(this.oa21Id);
        this._oa3 = (OperationalActivity)this.context.getSemanticElement(this.oa3Id);
        this._sf1 = (SystemFunction)this.context.getSemanticElement(this.sf1Id);
        this._sf11 = (SystemFunction)this.context.getSemanticElement(this.sf11Id);
        this._sf2 = (SystemFunction)this.context.getSemanticElement(this.sf2Id);
        this._sf21 = (SystemFunction)this.context.getSemanticElement(this.sf21Id);
        this._sf3 = (SystemFunction)this.context.getSemanticElement(this.sf3Id);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.modelName);
    }

    public void createCellValue(DTable table, final EObject lineObj, final EObject colObj) {
        new AbstractTableToolStep(this.context, DescriptionPackage.Literals.CREATE_CELL_TOOL, table){

            @Override
            protected void initToolArguments() {
                DLine line = TableTestingHelper.getLine(this.table, lineObj);
                DColumn column = TableTestingHelper.getColumn(this.table, colObj);
                CreateCellFromIntersectionCommand cellCommand = new CreateCellFromIntersectionCommand(this.table, line, column, "X");
                cellCommand.execute();
                DCell container = TableTestingHelper.getIntersectionCell(line, column);
                String tableCellMask = "X";
                this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, (Object)container);
                this._toolWrapper.setArgumentValue(ArgumentType.TABLE_CELL_MASK, (Object)tableCellMask);
            }

            protected void postRunTest() {
                super.postRunTest();
                FunctionRealization oaRealization = (FunctionRealization)TableTestingHelper.getRecentlyCreatedCapellaElement((EObject)FunctionTableTestFramework.this._sf1, FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTION_REALIZATIONS);
                FunctionTableTestFramework.assertNotNull((String)FunctionTableTestFramework.this.realizationNullErrMsg, (Object)oaRealization);
                FunctionTableTestFramework.assertEquals((String)NLS.bind((String)FunctionTableTestFramework.this.realizedOAErrMsg, (Object)FunctionTableTestFramework.this._sf1.getName(), (Object)FunctionTableTestFramework.this._oa1.getName()), (Object)FunctionTableTestFramework.this._oa1, (Object)oaRealization.getAllocatedFunction());
            }

            public Object getResult() {
                return null;
            }
        }.run();
    }
}

