/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.table.ju.utils;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.test.framework.helpers.TestHelper;
import org.polarsys.capella.test.table.ju.utils.AbstractTableActionCommand;

public abstract class HideRevealTableElementsCommand
extends AbstractTableActionCommand {
    private final List<DTableElement> _newVisibleElements = this.getVisibleElements();
    private final EAttribute _attribute;

    public HideRevealTableElementsCommand(DTable table_p, EAttribute attribute_p) {
        super(table_p);
        this._attribute = attribute_p;
    }

    @Override
    public void execute() {
        Assert.isTrue((boolean)this.isContextOk());
        for (DTableElement element : this.getAllElements()) {
            boolean visible = this._newVisibleElements.contains(element);
            if (!(visible ^ this.isVisibleElement(element))) continue;
            Command cmd = this._tableCommandFactory.buildSetValue((EObject)element, this._attribute.getName(), (Object)visible);
            this.executeCmd(cmd);
        }
    }

    private void executeCmd(final Command cmd_p) {
        TestHelper.getExecutionManager((EObject)this._table).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                cmd_p.execute();
            }
        });
    }

    @Override
    public boolean isContextOk() {
        boolean ret = false;
        if (this._newVisibleElements == null || this._newVisibleElements.isEmpty()) {
            return false;
        }
        block0: for (DTableElement element : this._newVisibleElements) {
            for (EAttribute attr : element.eClass().getEAllAttributes()) {
                if (!this._attribute.equals(attr)) continue;
                ret = true;
                continue block0;
            }
        }
        return ret;
    }

    private List<DTableElement> getAllElements() {
        return this.getAllElements(this._attribute);
    }

    private boolean isVisibleElement(DTableElement element_p) {
        return element_p instanceof DLine ? ((DLine)element_p).isVisible() : (element_p instanceof DColumn ? ((DColumn)element_p).isVisible() : false);
    }

    public abstract List<DTableElement> getVisibleElements();
}

