/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.transition.ju.testcases.la;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.transition.ju.Messages;
import org.polarsys.capella.test.transition.ju.ProjectionTestUtils;
import org.polarsys.capella.test.transition.ju.TopDownTransitionTestCase;
import org.polarsys.capella.test.transition.ju.model.ModelLaPa;

public class ActorTransition
extends TopDownTransitionTestCase {
    private LogicalComponentPkg laRootActorPkg;
    private LogicalComponent laActor1;
    private LogicalComponent laActor2;
    private LogicalComponent laActor3;
    private Interface laInterface1;
    private Interface laInterface2;
    private InterfaceImplementation laInterfaceImpl;
    private InterfaceUse laInterfaceUse;
    private LogicalComponentPkg laSubactorPkg;
    private LogicalComponent laSubactor1;
    private LogicalComponent laSubactor2;
    private ComponentPort laComponentPort1;
    private PhysicalComponentPkg paRootActorPkg;
    private PhysicalComponent paActor1;
    private PhysicalComponent paActor2;
    private PhysicalComponent paActor3;
    private InterfaceImplementation paInterfaceImpl;
    private InterfaceUse paInterfaceUse;
    private PhysicalComponentPkg paSubactorPkg;
    private PhysicalComponent paSubactor1;
    private PhysicalComponent paSubactor2;
    private ComponentPort paComponentPort1;

    private void initSession() {
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        this.context = new SessionContext(session);
        this.laRootActorPkg = (LogicalComponentPkg)this.getObject(ModelLaPa.rootLAActorPkgId);
        this.laActor1 = (LogicalComponent)this.getObject(ModelLaPa.actor1Id);
        this.laActor2 = (LogicalComponent)this.getObject(ModelLaPa.actor2Id);
        this.laActor3 = (LogicalComponent)this.getObject(ModelLaPa.actor3Id);
        this.laInterface1 = (Interface)this.getObject(ModelLaPa.interface1Id);
        this.laInterface2 = (Interface)this.getObject(ModelLaPa.interface2Id);
        this.laInterfaceImpl = (InterfaceImplementation)this.getObject(ModelLaPa.interfaceImplId);
        this.laInterfaceUse = (InterfaceUse)this.getObject(ModelLaPa.interfaceUseId);
        this.laSubactorPkg = (LogicalComponentPkg)this.getObject(ModelLaPa.subActorPkgId);
        this.laSubactor1 = (LogicalComponent)this.getObject(ModelLaPa.subActor1Id);
        this.laComponentPort1 = (ComponentPort)this.getObject(ModelLaPa.componentPort1Id);
        this.paRootActorPkg = (PhysicalComponentPkg)this.getObject(ModelLaPa.rootPAActorPkgId);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList("AllProjectionModels");
    }

    public void performTest() throws Exception {
        this.initSession();
        this.actor3TransitionTest();
        this.subActorPkgTransitionTest();
        this.rootActorPkgTransition1Test();
        this.rootActorPkgTransition2Test();
        this.rootActorPkgTransition3Test();
    }

    private void actor3TransitionTest() {
        this.performActorTransition(Arrays.asList(this.laActor3));
        this.paActor3 = (PhysicalComponent)this.paRootActorPkg.getOwnedPhysicalComponents().get(1);
        this.mustNotBeNull((EObject)this.paActor3);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paActor3.getName(), (Object)this.laActor3.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paActor3) == this.laActor3 ? 1 : 0) != 0);
    }

    private void subActorPkgTransitionTest() {
        this.performActorTransition(Arrays.asList(this.laSubactorPkg));
        this.paSubactorPkg = (PhysicalComponentPkg)this.paRootActorPkg.getOwnedPhysicalComponentPkgs().get(0);
        this.mustNotBeNull((EObject)this.paSubactorPkg);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubactorPkg.getName(), (Object)this.laSubactorPkg.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubactorPkg) == this.laSubactorPkg ? 1 : 0) != 0);
        this.paSubactor1 = (PhysicalComponent)this.paSubactorPkg.getOwnedPhysicalComponents().get(0);
        this.mustNotBeNull((EObject)this.paSubactor1);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubactor1.getName(), (Object)this.laSubactor1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubactor1) == this.laSubactor1 ? 1 : 0) != 0);
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)2L), (int)2, (int)this.paSubactor1.getContainedComponentPorts().size());
        this.paComponentPort1 = (ComponentPort)this.paSubactor1.getContainedComponentPorts().get(0);
        this.mustNotBeNull((EObject)this.paComponentPort1);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paComponentPort1.getName(), (Object)this.laComponentPort1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paComponentPort1) == this.laComponentPort1 ? 1 : 0) != 0);
    }

    private void rootActorPkgTransition1Test() {
        this.performActorTransition(Arrays.asList(this.laRootActorPkg));
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)5L), (int)this.paRootActorPkg.getOwnedPhysicalComponents().size(), (int)5);
        this.paActor1 = (PhysicalComponent)ProjectionTestUtils.getAllocatingComponent((Component)this.laActor1);
        this.mustNotBeNull((EObject)this.paActor1);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paActor1.getName(), (Object)this.laActor1.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paActor1) == this.laActor1 ? 1 : 0) != 0);
        this.paActor2 = (PhysicalComponent)ProjectionTestUtils.getAllocatingComponent((Component)this.laActor2);
        this.mustNotBeNull((EObject)this.paActor2);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paActor2.getName(), (Object)this.laActor2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paActor2) == this.laActor2 ? 1 : 0) != 0);
        this.paInterfaceImpl = (InterfaceImplementation)this.paActor1.getImplementedInterfaceLinks().get(0);
        this.mustNotBeNull((EObject)this.paInterfaceImpl);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paInterfaceImpl, (Object)this.laInterfaceImpl), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paInterfaceImpl) == this.laInterfaceImpl ? 1 : 0) != 0);
        ActorTransition.assertTrue((this.paInterfaceImpl.getImplementedInterface() == this.laInterface1 ? 1 : 0) != 0);
        this.paInterfaceUse = (InterfaceUse)this.paActor2.getUsedInterfaceLinks().get(0);
        this.mustNotBeNull((EObject)this.paInterfaceUse);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paInterfaceUse, (Object)this.laInterfaceUse), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paInterfaceUse) == this.laInterfaceUse ? 1 : 0) != 0);
        ActorTransition.assertTrue((this.paInterfaceUse.getUsedInterface() == this.laInterface2 ? 1 : 0) != 0);
        this.paSubactor1 = (PhysicalComponent)this.paSubactorPkg.getOwnedPhysicalComponents().get(0);
    }

    private void rootActorPkgTransition2Test() {
        this.performActorTransition(Arrays.asList(this.laRootActorPkg));
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)5), (int)this.paRootActorPkg.getOwnedPhysicalComponents().size(), (int)5);
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)1), (int)this.paSubactorPkg.getOwnedPhysicalComponents().size(), (int)1);
    }

    private void rootActorPkgTransition3Test() {
        this.laSubactor1.destroy();
        this.laSubactor2 = LaFactory.eINSTANCE.createLogicalComponent("Sub Actor 2");
        this.laSubactor2.setActor(true);
        this.laSubactorPkg.getOwnedLogicalComponents().add((Object)this.laSubactor2);
        this.laActor3.setName("LA Actor 3");
        this.performActorTransition(Arrays.asList(this.laRootActorPkg));
        this.mustNotBeNull((EObject)this.paSubactor1);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubactor1.getName(), null), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubactor1) == null ? 1 : 0) != 0);
        this.paSubactor2 = (PhysicalComponent)this.paSubactorPkg.getOwnedPhysicalComponents().get(1);
        this.mustNotBeNull((EObject)this.paSubactor2);
        ActorTransition.assertTrue((String)NLS.bind((String)Messages.RealizationError, (Object)this.paSubactor2.getName(), (Object)this.laSubactor2.getName()), (ProjectionTestUtils.getRealizedTargetElement((TraceableElement)this.paSubactor2) == this.laSubactor2 ? 1 : 0) != 0);
        ActorTransition.assertFalse((boolean)this.paActor3.getName().equals("LA Actor 3"));
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)5), (int)this.paRootActorPkg.getOwnedPhysicalComponents().size(), (int)5);
        ActorTransition.assertEquals((String)NLS.bind((String)Messages.ProjectionSizeError, (Object)2), (int)this.paSubactorPkg.getOwnedPhysicalComponents().size(), (int)2);
    }
}

